const fs = require("fs");
const iconv = require('iconv-lite');
const path = require('path');
const trans = require("./trans");
const md5 = require('md5');

//用于处理带base64图片的lottie文件，取出图片，同名lottie文件夹，写入代码"./src/lotties/"中;

//别再执行，会覆盖
// return

const pathName = "./lotties";
const outPath = "./resource";
//读文件夹
const files = fs.readdirSync(pathName);
//对每个json文件作处理
files.forEach(function (lottiesFileName) {
	// console.log(lottiesFileName)
	//后缀不是json的，不处理
	if (path.extname(lottiesFileName).indexOf(".json") < 0) return;
	//用文件名作为类名和资源文件夹名
	const cusName = lottiesFileName.substring(0, lottiesFileName.lastIndexOf(".json"));
	//读数据
	let data = iconv.decode(fs.readFileSync(pathName + "/" + lottiesFileName), "utf-8");//GBK
	//反序列化
	data = JSON.parse(data);
	//存图片
	const assets = data.assets;
	if (!assets || !assets.length) return;
	//删除属性
	delete data.assets;
	const copyAssets = [];
	const imgOutPath = outPath + "/" + cusName;//data.nm
	//建文件夹data.nm
	if (!fs.existsSync(imgOutPath)) fs.mkdirSync(imgOutPath);
	assets.forEach((e) => {
		//没有base64数据，可能是嵌套的
		if (!e.p) {
			copyAssets.push(e);
			return
		}
		let id = e.id;
		// let uuid = guid();
		// //存图片
		const base64 = e.p.replace(/^data:image\/\w+;base64,/, "");//去掉图片base64码前面部分data:image/png;base64
		const dataBuffer = /*new Buffer*/Buffer.from(base64, 'base64'); //把base64码转成buffer对象，
		
		//用用到该图片的图层的名字当作图片名，必须是.png结尾，为了图片去重
		let name = data.layers.find((l) => l.refId === id);
		//没找到图层，
		if (!name) {//再往嵌套图层里的找
			for (let ii = 0; ii < assets.length; ii++) {
				if (!assets[ii].p) {
					name = assets[ii].layers.find((l) => l.refId === id);
					if (name) break;
				}
			}
		}
		//还没找到图层，不处理
		if (!name) return
		
		//不用缓存了，直接用md5；
		name = md5(base64);
		//修改所有的refId
		data.layers.forEach((l) => {
			l.refId === id && (l.refId = name)
		})
		//还有嵌套的
		assets.forEach((a) => {
			if (!a.p) a.layers.forEach((l) => l.refId === id && (l.refId = name));
		})
		fs.writeFile(imgOutPath + "/" + name + ".png", dataBuffer, () => 0);
		
	});
	//如果存在嵌套图层的，assets加回
	if (copyAssets.length) data.assets = copyAssets;
	//开始删东西
	//是否3d
	delete data.ddd;
	//版本号，版本必须5.6.10，否则可能有问题
	delete data.v;
	//遍历删除图层东西
	for (let i = 0; i < data.layers.length; i++) {
		const l = data.layers[i];
		//是否3d,后缀,sr,ao,开始时间，混合模式，特效
		["ddd", "cl", "sr", "ao", "st", "bm", "ef"].forEach((e) => delete l[e]);
		//ks删除
		["o", "r", "p", "a", "s"].forEach((e) => {
			const d = l.ks[e];
			//ix不知道干嘛用，删了
			delete d.ix;
			//貌似标记0是没有关键帧的，1是有关键帧的
			delete d.a;
			//删除k里数据，都要用了，不能删，看情况用吧，如果不需要补间的，用Tween拼的，就删掉，不删只是文件大点
			// if (d.k.length && typeof d.k[0] == "object") {
			//     d.k.forEach((ee) => {
			//         ["i", "o", "ti", "to"/*, "h"*/].forEach((eee) => { delete ee[eee]; })//h需要判断是否是缓动
			//     })
			// }
		})
	}
	
	//导出代码到src的lotties文件夹，名字就是lottie动画名字，资源名字临时处理了，首页加载动画用图层的nm，bonustime用refid
	const endPath = './src/lotties';
	if (!fs.existsSync(endPath)) fs.mkdirSync(endPath);
	//文件名字修改，中划线变成下划线，中文变拼音
	const fileName = trans(cusName/*data.nm*/).replace(/-/g, "_");
	//导出对象直接用lottie动画名字
	const endFile = `export const ${fileName} = ${JSON.stringify(data, "", "\t")}`;
	//文件名字用lottie动画名字
	fs.writeFileSync(endPath + "/" + fileName + ".ts", endFile);
	
	console.log("生成文件：" + fileName + ".ts");
});
