import { Component } from "react";

import "./PrizePanel.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { _throttle } from "@/utils/utils";
import { PageCtrl } from "@/core/ctrls/PageCtrl";
import NewRecordPage from '../../pages/newRecordPage/index.jsx';

export class PrizePanel extends Component<any, any> {

    componentDidMount() {
    }

    clickClose = () => {
        ModalCtrl.closeModal();
    }

    clickBtn = _throttle(() => {
        const {type} = this.props;

        if(type == 'red') {
            PageCtrl.changePage(NewRecordPage, {tab: 2})
        }

        ModalCtrl.closeModal();
    })

    render() {

        const {optionImg, optionName, type} = this.props;

        return <div className="PrizePanel modal_center">
            <div className="bg2"/>
            <img className="img" src={optionImg}/>
            <div className="prizeName">{optionName}</div>
            <Button className={`btn md${type == 'red' ? '26' : '18'}`}onClick={this.clickBtn}/>
            {type != 'red' && <div className="tips">奖品可在【首页】_【我的奖品】中查看</div>}
            <Button className="close" onClick={this.clickClose}/>
        </div>
    }


}
