//sdk
// <script src="//yun.duiba.com.cn/db_games/libs0924/howler.min.js"></script>
var resPath = "https://yun.duiba.com.cn/db_games/qx/hyundaiXXL/sound/";
var gameMusicBg = "https://yun.duiba.com.cn/aurora/assets/1f591de154f744a65f16fc2b86ae7cd069ac4421.mp3";


var boom = 'https://yun.duiba.com.cn/spark/assets/0cebbed9233d99ac4fb8a78d875f5efca9bad444.mp3';
var props = "https://yun.duiba.com.cn/spark/assets/34666d18dcc6c5054257c6914268f67c67bae49d.mp3";
var gold = "https://yun.duiba.com.cn/spark/assets/729a54f12f529cfef03db43715e0985d1f0d4f72.mp3";

export enum SoundType {
    gameMusicBg = "gameMusicBg",
}
let isMuteStatus = false
let isPlayBg = false
export function cusPlaySound(soundType: number, loop: boolean = false, isMute: boolean = false) {
    switch (soundType) {
        case 1:
            if (!isPlayBg) {
                isPlayBg = true
                playSound(gameMusicBg, loop, isMuteStatus)
            }
            break
        case 2:
            playSound(boom, loop, isMuteStatus)
            break
        case 3:
            playSound(props, loop, isMuteStatus)
            break
        case 4:
            playSound(gold, loop, isMuteStatus)
            break
        default:
            break
    }
    // playSound(unionPath, loop);
}

/**
 * 提前加载音频
 * @param type
 */
export function preloadSound(type: SoundType) {
    let src = resPath + type + ".mp3";
    soundHash[src] = new Howl({
        src: src,
        preload: true,
    });
}

/**
 * 根据路径记录
 */
const soundHash: { [key: string]: Howl } = {};
export function playSound(src: string, loop: boolean = false, isMute: boolean = false) {

    console.log('测试音效isMute', isMute);

    let sound: Howl;
    //循环的，且有缓存，取缓存的
    if (soundHash[src] && loop) sound = soundHash[src]
    //没有就新建
    if (!sound) sound = new Howl({ src: [src], autoplay: false, loop });
    //记录下，方便停止
    soundHash[src] = sound;
    //不循环删除缓存
    if (!loop) sound.on('stop', function () { delete soundHash[src] });
    if (isMute) {
        // 静音
        sound.stop()
    } else {
        //播放
        console.log("播放")
        sound.mute(false)
        sound.play();
    }

    // console.log(sound)
    //console.log('测试是否播放音效',src);
    //返回一个，可以自行控制
    return sound;
}

export function stopSound(src: string) {
    if (soundHash[src]) soundHash[src].stop();
}

export function muteAllSound() {
    isMuteStatus = false
    console.log(isMuteStatus)
    for (let key in soundHash) soundHash[key].mute(false);
}

export function resumeAllSound() {
    isMuteStatus = true
    console.log(isMuteStatus)
    for (let key in soundHash) soundHash[key].mute(true);
}

export function stopAllSound() {
    for (let key in soundHash) soundHash[key].stop();
}

export function playAllSound() {
    for (let key in soundHash) soundHash[key].play();
}


//设置隐藏属性和改变可见属性的事件的名称
let hidden: string, visibilityChange: string;
if (typeof document.hidden !== 'undefined') {
    hidden = 'hidden';
    visibilityChange = 'visibilitychange';
} else if (typeof document['msHidden'] !== 'undefined') {
    hidden = 'msHidden';
    visibilityChange = 'msvisibilitychange';
} else if (typeof document['webkitHidden'] !== 'undefined') {
    hidden = 'webkitHidden';
    visibilityChange = 'webkitvisibilitychange';
}

const handleVisibilityChange = () => {
    if (document.visibilityState == "visible") {
        playAllSound();
        console.log("网页显示")
    }
    else if (document.visibilityState == "hidden") {
        stopAllSound()
        console.log("网页隐藏")
    }
};

document.addEventListener(
    visibilityChange,
    handleVisibilityChange,
    false
);

window.onbeforeunload = function () {
    //发接口
}

// window.addEventListener('beforeunload', ()=>{
//     //发接口出去，

// })


// document.body['onbeforeunload'] = () => {

// }

