/*
 * rollup.test.mjs
 * Created by 还有醋v on 2022/6/6.
 * Copyright © 2021 haiyoucuv. All rights reserved.
 */

import json from "@rollup/plugin-json";
import resolve from "@rollup/plugin-node-resolve";
import commonjs from "rollup-plugin-commonjs";
import livereload from "rollup-plugin-livereload";
import progress from "rollup-plugin-progress";
import babel from "@rollup/plugin-babel";
import peerDepsExternal from "rollup-plugin-peer-deps-external";
import styles from "rollup-plugin-styles";

export default {
	input: "src/app.jsx",
	cache: true,
	output: {
		file: "debug/output.js",
		format: "umd",
		sourcemap: true,
	},
	external: [
		'react',
		'react-dom',
		'classname',
		'**/node_modules/**'
	],
	plugins: [
		peerDepsExternal(),
		progress(),
		styles(),
		babel.babel({
			presets: [
				"@babel/preset-env",
				"@babel/preset-react"
			],
			babelHelpers: "bundled"
		}),
		resolve({
			jsnext: true,
			preferBuiltins: true,
			browser: true,
			extensions: [".js", ".jsx"],
		}),
		commonjs({
			extensions: [".js", ".jsx"],
		}),
		json(),
		livereload(),
	],
};
