import React from 'react';
import { observer } from 'mobx-react';
import './HomePage.less';
import store from "@/store/store.ts";
import { Button, Toast } from "@grace/ui";
import MyPrize from '../MyPrize/MyPrize';
import Rulepop from '@/panels/rulepop/rulepop';
import { PageCtrl } from '@/core/ctrls/PageCtrl';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';

@observer
class HomePage extends React.Component<any, any> {

  root: HTMLDivElement;

  async componentDidMount() {
    await store.judgeIsWhiteUser();

  }

  clickPrize = () => {
    PageCtrl.changePage(MyPrize);
  }

  clickRule = () => {
    ModalCtrl.showModal(Rulepop)
  }

  clickCredits = () => {
    wx.miniProgram.navigateTo({ url: "/packages/user/points?source=duiba" });
  }

  clickActPre = () => {
    Toast.show("活动未开始");
  }

  clickActEnd = () => {
    Toast.show("活动已结束");
  }

  componentWillUnmount(): void {
  }
  render() {
    const { creditsNum, guideFlag, actStartTime, currentTime, actEndTime } = store.indexData
    return <>
      <div className="homepage" ref={(el) => this.root = el}>
        <div className="homeRoot">

          <Button className="credits"
            onClick={this.clickCredits}>{creditsNum > 999999 ? "999999+" : creditsNum}</Button>
          {/*<Button className="cash"><span>￥</span>32.88</Button>*/}

          {currentTime >= actEndTime && <div className="ActEndMask" onClick={this.clickActEnd} />}

          <Button className="rule" onClick={this.clickRule} />
          <Button className="prize" onClick={this.clickPrize} />

          {currentTime < actStartTime && <div className="ActPreMask" onClick={this.clickActPre} />}
        </div>

      </div>
      {/*{!guideFlag && <GuidePanel />}*/}
    </>;
  }
}

export default HomePage;
