'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './sharePage.less';
import { _throttle, windowJumpUrl, CHANNEL, generateUUID, _asyncThrottle } from '@/utils/utils';
import { copyToClipboard } from '@spark/utils';
import { Toast } from "@grace/ui";
import API from '@/api';
import { RATE_NAME } from '@/AppTools';

@observer
class SharePage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      pageInfo: {},
      btn: 1 // 1-助力 2-我也领取百万理财体验金
    }
  }

  componentDidMount() {
    const like_uuid = generateUUID()
    if (!localStorage.getItem("like_uuid")) {
      localStorage.setItem("like_uuid", like_uuid)
    }
    this.getPageInfo()
  }

  getPageInfo = async () => {
    const { success, data } = await API.getSharePageInfo({
      channel: CFG.channel,
      inviteCode: CFG.inviteCode
    })
    if (success) {
      this.setState({
        pageInfo: data || {}
      })
    }
  }

  /** 唤端 */
  toApp = _asyncThrottle(() => {
    // if (CFG.inviteCode) {
    //   copyToClipboard(CFG.inviteCode);
    //   Toast.show("复制成功")
    // }
    if (CFG.channel === CHANNEL.HXBANK) {
      // 华夏银行 可唤端 不可带参
    } else if (CFG.channel === CHANNEL.HXLC) {
      // 华夏理财 无唤端方法
    } else {
      // 其他三方渠道 无唤端方法
    }
    setTimeout(() => {
      if (this.state.pageInfo?.jumpUrl) {
        windowJumpUrl(this.state.pageInfo.jumpUrl)
      }
    }, 300)
  })

  doAssist = _asyncThrottle(async () => {
    const { success, message, code } = await API.doAsistInSharePage({
      channel: CFG.channel,
      deviceId: localStorage.getItem('like_uuid'),
      inviteCode: CFG.inviteCode,
    })
    if (success) {
      Toast.show('成功为好友助力～')
      this.setState({
        btn: 2
      })
    } else {
      if (code === '900002') {
        Toast.show('活动已结束，感谢您的关注～')
      } else {
        if (['300002', '300003', '300004', '300005'].includes(code)) {
          this.setState({
            btn: 2
          })
        }
        Toast.show(message)
      }
    }

  })

  render() {
    const { boolWealth, recommendProductConfig, amount } = this.state.pageInfo || {}
    return (
      <div className="sharePage">
        <span className="bg"></span>
        {!boolWealth && <span className="title1">
          <span className='title1-text'>
            {`${((amount || 0) / 100).toFixed(2)}元`}
          </span>

        </span>}
        {boolWealth && <span className="title2"></span>}
        {this.state.btn === 1 && <span className="doAssitBtn md30" onClick={() => {
          this.doAssist()
        }}></span>}

        {this.state.btn === 2 && <span className="goAppBtn" onClick={() => {
          this.toApp()
        }}></span>}

        <div className="content">
          {
            (recommendProductConfig || []).map((el, index) => {
              return <div className='proItem' key={index}>
                <span className='pro_name'>{el.name}</span>
                <div className='info_con'>
                  <div className='rate_con'>
                    <p className='pro_rate'>{Number(el.rate / 100).toFixed(2) + '%'}</p>
                    <p className='pro_rate_label'>{RATE_NAME[el.type] || '年化收益率'}</p>
                  </div>
                  <div className='guize_con'>
                    <p className='pro_guize'>{el.shenShuGuiZei}</p>
                    <p className='pro_fengxian'>
                      <span style={{ marginRight: '5px' }}>{`${el.fengXian}`}</span>
                      |
                      <span style={{ marginLeft: '5px' }}>{`${el.qigouText}`}</span>
                    </p>
                  </div>
                  <div className='btn_con'>
                    <span className='check-btn' onClick={_asyncThrottle(() => {
                      this.toApp()
                    })}></span>
                  </div>
                </div>
                {index !== (recommendProductConfig || []).length - 1 && <span className='line'></span>}
              </div>
            })
          }
        </div>
      </div>
    );
  }
}
export default SharePage;
