import React from 'react';
import { observer } from 'mobx-react';
import './TurnTable.less';
import { CircleTurntable } from "@spark/circle-turntable";
// import turnTableStore from "@src/store/TurnTableStore";
import { Button, Toast } from "@grace/ui";
import { _asyncThrottle } from "@/utils/utils.ts";
import API from "@/api";
import resStore from "@/store/ResStore.ts";
import classNames from "classnames";
import { NoPrizePanel } from "@/panels/NoPrizePanel/NoPrizePanel.tsx";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { PrizePanel } from "@/panels/PrizePanel/PrizePanel.tsx";
import store from '@/store/store';

@observer
class TurnTable extends React.Component {

    turntableRef = null; // 大转盘
    btnStarting = false; // 转盘是否启动
    drawResultInfo: any = {};

    async componentDidMount() {
    }

    onStop = () => {
        this.btnStarting = false;
        resStore.updateInfo();

        if (this.drawResultInfo.prizeId == "thanks") {
            ModalCtrl.showModal(NoPrizePanel, {...this.drawResultInfo, md: '34'});
        } else {
            ModalCtrl.showModal(PrizePanel, {...this.drawResultInfo, md: '33'});
        }
    }

    // 开始抽奖
    drawHandle = _asyncThrottle(async () => {
        if (this.btnStarting) return false;

        if (store.indexData.currentTime >= resStore.info.drawEndTime) {
            return Toast.show("活动已结束");
        }

        if (resStore.info.remainDrawTime <= 0) {
            return Toast.show("已抽过奖哦");
        }

        this.btnStarting = true;

        const { success, data } = await API.drawJoin();
        if (!success) {
            this.btnStarting = false;
            return;
        }
        this.drawResultInfo = data;

        this.turntableRef.launch();
        const index = resStore.info.prizeInfo?.findIndex((item) => item.prizeId === this.drawResultInfo.prizeId);
        this.turntableRef.braking(index);
    });


    render() {

        const { prizeInfo, remainDrawTime } = resStore.info;

        return <div className="TurnTable">
            <CircleTurntable
                className="tt_box"
                // @ts-ignore
                ref={(ref) => (this.turntableRef = ref)}
                options={prizeInfo || []}
                angleOffset={180 / 6 + 10} // 角度偏移量
                radian={100} // 奖项半径
                launchDuration={1000} // 启动时间
                // 大转盘背景
                renderBackground={<div className="turntable_bg"></div>}
                // 大转盘指针
                renderStartButton={<div className="ttBtn"/>}
                // 渲染奖品信息
                renderOption={(option) => {
                    return <div className="prize_item">
                        <div className="prize_name">{option.prizeName}</div>
                        <img className="prize_img" src={option.prizeImg} alt=""/>
                    </div>;
                }}
                didStop={this.onStop}
            />

            <Button className={classNames("drawBtn md32", {
                enable: remainDrawTime > 0,
                disable: remainDrawTime <= 0,
            })} onClick={this.drawHandle}/>

        </div>;
    }
}

export default TurnTable;
