import React from 'react';
import { observer } from 'mobx-react';
import styles from './RecordPage.module.less';
import { Button } from "@grace/ui";
import API from "@/api";
import { dateFormatter } from "@/utils/utils.ts";
import { PageCtrl } from "@/core/ctrls/PageCtrl.tsx";
import HomePage from "@/pages/HomePage/HomePage.tsx";

@observer
class RecordPage extends React.Component<any, any> {

    state = {
        list: [],
    }

    async componentDidMount() {
        this.updateList();
    }

    pageNum: number = 1;
    pageSize: number = 50;
    haveMore: boolean = true;

    async updateList() {

        const { pageNum, pageSize, haveMore } = this;

        if (!haveMore) return;

        const { success, data } = await API.tradeRecords({ pageNum, pageSize });
        if (!success) return;

        this.pageNum++;
        this.haveMore = data.haveMore;

        const list = this.state.list.concat(data.list);

        this.setState({ list, })
    }

    clickBack = () => {
        PageCtrl.changePage(HomePage);
    }

    render() {
        const { list } = this.state;

        return <div className={styles.RecordPage}>
            <div className={styles.pageTitle}/>
            <Button className={styles.backBtn} onClick={this.clickBack}/>
            {list?.length
                ? <div className={styles.list}>
                    {
                        list.map((item) => {

                            const state = {
                                0: { txt: "购买待确认", color: "rgba(0,0,0,0.6)" },
                                1: { txt: "购买成功", color: "#ee4e32" },
                                2: { txt: "赎回成功", color: "#1b8a4f" },
                                3: { txt: "购买失败", color: "rgba(0,0,0,0.6)" },
                            }[item.tradeStatus];

                            return <div className={styles.item}>
                                <div className={styles.title}>{item.desc}</div>
                                <div
                                    className={styles.date}>{dateFormatter(item.gmtCreate, "yyyy.MM.dd hh:mm:ss")}</div>
                                <div className={styles.num}>¥{item.amount / 100}</div>
                                <div className={styles.state} style={{ color: state.color }}>{state.txt}</div>
                            </div>
                        })
                    }
                </div>
                : <div className={styles.listNone}>暂无交易记录哦</div>
            }
        </div>;
    }
}

export default RecordPage;
