import { Component } from "react";

import "./newbieModal.less";
import { Button, Toast } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";
import { CircleTurntable } from "@spark/circle-turntable";
import { NoPrizePanel } from "../NoPrizePanel/NoPrizePanel";
import { PrizePanel } from "../PrizePanel/PrizePanel";
import { _asyncThrottle } from "@/utils/utils";
import store from "@/store/store";
import API from "@/api";

export class NewbieModal extends Component<any, any> {

    componentDidMount() {
    }

    clickClose = () => {
        ModalCtrl.closeModal();
    }

    turntableRef = null; // 大转盘
    btnStarting = false; // 转盘是否启动
    drawResultInfo: any = {};

    onStop = () => {
        this.btnStarting = false;
        // resStore.updateInfo();
        ModalCtrl.closeModal();
        if (this.drawResultInfo?.prizeId == "thanks" || !this.drawResultInfo?.prizeId) {
            ModalCtrl.showModal(NoPrizePanel, {type: 'new_turntable', ...this.drawResultInfo});
        } else {
            ModalCtrl.showModal(PrizePanel, {type: 'new_turntable', optionImg: this.drawResultInfo?.prizeImg, optionName: this.drawResultInfo?.prizeName});
        }
    }

    // 开始抽奖
    drawHandle = _asyncThrottle(async () => {


        const {actPrizeVO, type} = this.props || {};

        if(type == 1) {
            this.clickClose();
            // @ts-ignore
            store.homeRoot.scrollTop = 1800 * window.remScale;
            return;
        }

        if (this.btnStarting) return false;

        // if (store.indexData.currentTime >= resStore.info.drawEndTime) {
        //     return Toast.show("活动已结束");
        // }

        // if (resStore.info.remainDrawTime <= 0) {
        //     return Toast.show("已抽过奖哦");
        // }

        this.btnStarting = true;

        const { success, data } = await API.newbieDraw();
        await store.updateIndex();
        if (!success) {
            this.btnStarting = false;
            return;
        }
        this.drawResultInfo = data;

        this.turntableRef.launch();
        const index = actPrizeVO?.findIndex((item) => item.prizeId === this.drawResultInfo.prizeId);
        if(index == -1) return;
        this.turntableRef.braking(index);
    });

    render() {
        const { type, actPrizeVO } = this.props || {};

        return <div className="newbieModal modal_center">
            <div className={`bg${type}`}/>
            {actPrizeVO?.length > 0 && <div className="TurnTable1">
                <CircleTurntable
                    className="tt_box"
                    // @ts-ignore
                    ref={(ref) => (this.turntableRef = ref)}
                    options={actPrizeVO}
                    angleOffset={180 / 6 + 10} // 角度偏移量
                    radian={100} // 奖项半径
                    launchDuration={1000} // 启动时间
                    // 大转盘背景
                    renderBackground={<div className="turntable_bg"></div>}
                    // 大转盘指针
                    renderStartButton={<div className="ttBtn"/>}
                    // 渲染奖品信息
                    renderOption={(option) => {
                        return <div className="prize_item">
                            <div className="prize_name">{option?.prizeName}</div>
                            <img className="prize_img" src={option?.prizeImg} alt=""/>
                        </div>;
                    }}
                    didStop={this.onStop}
                />
            </div>}
            {type == 1 && <Button className="feelBtn md12" onClick={this.drawHandle}/>}
            {type == 2 && <Button className="drawBtn md13" onClick={this.drawHandle}/>}
            <Button className="close" onClick={this.clickClose}/>
        </div>
    }


}
