
/**
 * 用到的和业务相关的
 * 各种静态方法汇总
 * 
 * 获取修改链接参数
 * 获取cookie
 * 缓存相关
 * 数组相关
 * 
 */
export class GTool {
    /**
     * 读取缓存
     */
    public static readCache(key: string/*, type: string = 'localStorage'*/) {
        //@ts-ignore
        return my ? my.getStorageSync({ key: key }).data : localStorage ? localStorage.getItem(key) : null;
        // if (!window.localStorage) {
        //     return false;
        // }
        // return window[type].getItem(key);
    }

    /**
     * 写缓存
     */
    public static writeCache(key: string, value: any = 'true'/*, type: string = 'localStorage'*/) {
        //@ts-ignore
        my ? my.setStorageSync({ key: key, data: value }) : localStorage && localStorage.setItem(key, value);
        // if (!window.localStorage) {
        //     // trace(Func.replace(SysLang.lang_012, [type]));
        //     return;
        // }
        // window[type].setItem(key, value);
    }

    /**
     * 获得cacheKey今日次数
     * 第二天归0重新计数
     * @param cacheKey 
     */
    public static returnTodayTimes(cacheKey: string): number {
        var year1 = this.readCache("year" + cacheKey);
        var month1 = this.readCache("month" + cacheKey);
        var day1 = this.readCache("day" + cacheKey);

        var date = new Date();
        var year2 = date.getFullYear().toString();
        var month2 = date.getMonth().toString();
        var day2 = date.getDate().toString();

        if (this.int(year2) <= this.int(year1)) {
            if (this.int(month2) <= this.int(month1)) {
                if (this.int(day2) <= this.int(day1)) {
                    return this.int(this.readCache(cacheKey));
                }
            }
        }
        //如果不是同一天了，归0
        var today = "0";
        this.writeCache("year" + cacheKey, year2);
        this.writeCache("month" + cacheKey, month2);
        this.writeCache("day" + cacheKey, day2);
        this.writeCache(cacheKey, today);
        return 0;
    }

    /**
     * 随机，两个参数时是数值范围，比如randomT(1,10),一个参数时是数组
     * @param e 
     * @param n 
     */
    public static randomT(e, n?) {
        return e && "number" == typeof e.length && e.length ? e[Math.floor(Math.random() * e.length)] : ("number" != typeof n && (n = e || 1, e = 0), e + Math.random() * (n - e))
    }

    /**
     * 从数组中移除一个元素
     * @param e 元素
     * @param arr 数组
     */
    public static removeEle(e, arr) {
        var index = arr.indexOf(e);
        if (index >= 0) {
            arr.splice(index, 1)
        }
    }

    /**
     * 数组中插入一个数值，按顺序的
     * 数组是从小到大的
     * @param num 
     * @param arr 
     */
    public static insert(num, arr) {
        for (var i = arr.length - 1; i >= 0; i--) {
            if (num > arr[i]) {
                //在arr[i]后加num
                arr.splice(i + 1, 0, num);
                break
            }
        }
    }

    /**
     * 获取start到end里的n个整数
     * @param start 0
     * @param end 19
     * @param n 3
     */
    public static getRandomNumber(start: number, end: number, n: number): number[] {
        var arr = [];
        for (var i = 0; i < n; i++) {
            var number = Math.floor(Math.random() * (end - start + 1) + start);
            if (arr.indexOf(number) < 0) {
                arr.push(number);
            } else {
                i--;
            }
        }
        return arr;
    }
    /**
     * 打乱数字数组，改变原数组
     * @param arr 
     */
    public static disturbNumberArr(arr: number[]) {
        arr.sort(function () {
            return (0.5 - Math.random());
        });
    }
    public static disturbArr(arr: any[]) {
        return arr.sort(function () {
            return (0.5 - Math.random());
        });
    }

    /**
     * 其实打乱数组取前几个就行
     * 随机取数组arr中count个元素，不改变原数组
     * @param arr 
     * @param count 
     */
    public static getRandomArrayElements(arr: any[], count: number) {
        var shuffled = arr.slice(0), i = arr.length, min = i - count, temp, index;
        //如果count大于等于数组长度，返回所有数组
        if (min <= 0) return shuffled;
        if (count <= 0) return [];
        //随机排序，然后取出后面的元素
        while (i-- > min) {
            index = Math.floor((i + 1) * Math.random());
            temp = shuffled[index];
            shuffled[index] = shuffled[i];
            shuffled[i] = temp;
        }
        return shuffled.slice(min);
    }
    /**
     * 随机取数组arr中count个元素，原数组减少count个
     * @param arr 
     * @param count 
     */
    public static getRandomArrayElementsEx(arr: any[], count: number): any[] {
        //如果count大于等于数组长度，返回所有数组
        if (arr.length <= count) return arr.slice();
        if (count <= 0) return [];
        var arrCopy = arr.slice();
        var outArr = [];
        while (count--) {
            var rand = Math.floor(Math.random() * arrCopy.length);
            var ele = arrCopy.splice(rand, 1)[0];
            outArr.push(ele);
        }
        return outArr
    }


    /**
     * 向下取整，或把字符串执行parseInt(字符串转数字取整数部分)
     * @param n 数字或字符串
     */
    private static int(n: any): number {
        return n >> 0;//~~n
    };

    /**
     * emoji正则式
     */
    public static emojiReg = /[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF][\u200D|\uFE0F]|[\uD83C|\uD83D|\uD83E][\uDC00-\uDFFF]|[0-9|*|#]\uFE0F\u20E3|[0-9|#]\u20E3|[\u203C-\u3299]\uFE0F\u200D|[\u203C-\u3299]\uFE0F|[\u2122-\u2B55]|\u303D|[\A9|\AE]\u3030|\uA9|\uAE|\u3030/ig


    /**
     * 在字符串间加空格
     * @param str 
     */
    public static addSpaceInString(str: string) {
        if (!str.length || str.length == 1) return str;
        var txt = "";
        //每个字符后加空格
        for (var i = 0; i < str.length - 1; i++) {
            txt = txt + str[i] + " ";
        }
        txt = txt + str[str.length - 1]
        return txt
    }

    /**
     * 毫秒剩余时间转成时分秒
     * 1小时1分1秒
     * @param timeStamp 
     */
    public static getShiFenMiaoByTimeStamp(timeStamp: number) {
        var hours: any = Math.floor((timeStamp % (1000 * 60 * 60 * 24)) / (1000 * 60 * 60));
        var minutes: any = Math.floor((timeStamp % (1000 * 60 * 60)) / (1000 * 60));
        // var seconds: any = (timeStamp % (1000 * 60)) / 1000;
        var seconds: any = Math.floor((timeStamp % (1000 * 60)) / 1000);
        hours = hours < 10 ? ('0' + hours) : hours;
        minutes = minutes < 10 ? ('0' + minutes) : minutes;
        seconds = seconds < 10 && seconds >= 1 ? ('0' + seconds) : seconds;
        // return hours + " :" + minutes + " :" + seconds;
        return hours + "小时" + minutes + "分" + seconds + "秒";
    }

    /**
     * 获取字符串真实长度，中文算两个
     * @param str 
     */
    static getRealStringLength(str: string): number {
        var realLength = 0, len = str.length, charCode = -1;
        for (var i = 0; i < len; i++) {
            charCode = str.charCodeAt(i);
            if (charCode >= 0 && charCode <= 128) realLength += 1;
            else realLength += 2;
        }
        return realLength;
    }
    /**
     * 切字符串
     * @param str 
     * @param realLength 
     * @param tailStr 
     */
    static cutStringAcoRealLength(str: string, limit: number, tailStr: string = "...") {
        let length = 0;
        let out = "";
        for (let i of str) {
            let charCode = i.charCodeAt(0);
            if (charCode >= 0 && charCode <= 128) length += 1;
            else length += 2;

            if (length <= limit) {
                out = out.concat(i);
            } else {
                out = out.concat(tailStr);
                break;
            }
        }
        return out;
    }
}