// var aa = this.addChild(new RichText(
//     [
//         { text: "啊请问请问", style: { color: "#000000", size: 30 } },
//         { text: "=2134324234啊请问请问", style: { color: "#ff0000", size: 30 } },
//         { text: "驱蚊器问问", style: { color: "#000000", size: 30 } }
//     ]
// ))
// aa.text = [
//     { text: "啊请问请问", style: { color: "#000000", size: 30 } },
//     { text: "=2134", style: { color: "#ff0000", size: 30 } },
//     { text: "驱蚊器问问", style: { color: "#000000", size: 30 } }
// ]
// aa.position.set(375, 800);

// [{text: "测试"，style:{color: ""}},{},{}]
import TextField = FYGE.TextField;
import Container = FYGE.Container;

interface IRichTextEle {
    text: string,
    style: { color: string, size: number }
}
export class RichText extends Container {
	declare children : TextField[];

    private static cache: FYGE.TextField[] = []
    /**
     *
     * @param text
     */
    constructor(text?: IRichTextEle[]) {
        super()
        if (text) this.text = text;
    }
    /**
     * 水平对齐方式，默认居中
     */
    get textAlign() {
        return this._textAlign
    }
    set textAlign(value: FYGE.TEXT_ALIGN) {
        if (this._textAlign !== value) {
            this._textAlign = value;
            this.adaptate();
        }
    }
    private _textAlign: FYGE.TEXT_ALIGN = FYGE.TEXT_ALIGN.CENTER;
    /**
     * 垂直居中方式，默认居中
     */
    get verticalAlign() {
        return this._verticalAlign
    }
    set verticalAlign(value: FYGE.VERTICAL_ALIGN) {
        if (this._verticalAlign !== value) {
            this._verticalAlign = value;
            this.adaptate();
        }
    }
    private _verticalAlign: FYGE.VERTICAL_ALIGN = FYGE.VERTICAL_ALIGN.MIDDLE;
    /**
     * 文字间隙
     */
    get gap(): number {
        return this._gap;
    };
    set gap(value: number) {
        if (this._gap != value) {
            this._gap = value;
            this.adaptate();
        }
    };
    private _gap: number = 0;
    /**
     * 文本
     */
    private _text: IRichTextEle[];
    /**
     * 按顺序
     */
    get text(): IRichTextEle[] {
        return this._text
    }
    /**
     *
     */
    set text(value: IRichTextEle[]) {
        let i;
	    this._text = value;
	    const arr = value || [];
	    for (i = 0; i < arr.length; i++) {
		    const a = arr[i];
            const c: TextField = this.children[i] || this.addChild(RichText.cache.shift() || new TextField());
            c.text = a.text;
            c.fillColor = a.style.color;
            c.size = a.style.size;
        }
        //如果多了，去掉后面的，回收
        if (this.children.length > arr.length) {
            //移除后序
            for (i = this.children.length - 1; i >= arr.length; i--) {
                const c = this.children[i];
                this.removeChild(c);
                RichText.cache.push(c);
            }
        }
        //适配
        this.adaptate()
    }

    /**
     * 适配，
     */
    private adaptate() {
        let i;
	    if (!this.children.length) return
        var len = this.children.length;
        //算总长度
        var sum = 0;
        for (var m = 0; m < len; m++) {
            sum += this.children[m].textWidth;
        }
        sum += (len - 1) * this._gap;
        //算出左边第一个元素的位置
        var left: number;
        if (this._textAlign == FYGE.TEXT_ALIGN.LEFT) {
            left = 0
        }
        else if (this._textAlign == FYGE.TEXT_ALIGN.RIGHT) {
            left = -sum
        } else {
            left = -sum / 2
        }
        var temSum = 0;
        for (i = 0; i < this.children.length; i++) {
            this.children[i].x = left + temSum
            temSum += this.children[i].textWidth + this._gap;
        }
        var up: number;
        if (this._verticalAlign == FYGE.VERTICAL_ALIGN.UP) {
            up = 0
        }
        else if (this._verticalAlign == FYGE.VERTICAL_ALIGN.DOWN) {
            up = -1
        } else {
            up = -1 / 2
        }
        for (i = 0; i < this.children.length; i++) {
            this.children[i].y = this.children[i].textHeight * up;
        }
    }
}
