/*
 * Config.ts
 * Created by 还有醋v on 2022/6/2.
 * Copyright © 2022 haiyoucuv. All rights reserved.
 */


interface IConfig {
	dropSpeed?: number, // 掉落速度(px/s)
	interval?: number,  // 掉落间隔事件(s)
	player?: string,    // 任务图片
	rainObj?: string[],   // 掉落物图片
}

const gameConfig: IConfig = {
	dropSpeed: 650,             // 掉落速度(px/s)
	interval: 0.3,             // 掉落间隔事件(s)
	player: "人物.png",          // 任务图片
	rainObj: ["金币.png", "红包1.png", "红包2.png", "红包3.png", "fudai.png"],         // 掉落物图片
};

export default gameConfig;

export function setConfig(obj: IConfig) {
	for (let k in obj) gameConfig[k] = obj[k];
}

