import { Component } from "react";

import "./BuyPanel.less";
import { Button } from "@grace/ui";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl.tsx";

export class BuyPanel extends Component<any, any> {

    componentDidMount() {
    }

    clickOk = () => {
        ModalCtrl.closeModal();
        this.props?.call();
    }
    clickClose = () => {
        ModalCtrl.closeModal();
    }

    render() {

        const {name, amount} = this.props;

        return <div className="BuyPanel modal_center">
            <div className="bg"/>
            <div className="tip">您申请模拟购买{name}产品{amount}元</div>
            <Button className="btn md12" onClick={this.clickOk}/>
            <Button className="cancel md11" onClick={this.clickClose}/>
            <Button className="close" onClick={this.clickClose}/>
        </div>
    }


}
