'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import { ModalCtrl } from '@/core/ctrls/ModalCtrl';
import { Button, Toast } from '@grace/ui';
import { _asyncThrottle, formatThousand } from '@/utils/utils';
import Countdown from '@/core/components/ComCountdown/index.jsx';
import store from '@/store/store';
/* 电话号码验证规则 **/
export const REG_TEL = /^1[0-9]{10}$/;

@observer
class RedPackCountPanel extends React.Component {
  constructor(props) {
    super(props);
  }

  close = () => {
    ModalCtrl.closeModal()
  }

  render() {
    const { redRainCountDownTime } = store.indexData
    return (<>
      <div className="redPackCountPanel modal_center">
        <span className="bg"></span>
        <div>
          <Countdown
            leftT={redRainCountDownTime * 1000}
            renderText={data => {
              let { day, hour, minute, second } = data
              let hourNum = Number(day) * 24 + Number(hour);
              hourNum = hourNum >= 10 ? hourNum + "" : '0' + hourNum;
              minute = minute + "";
              second = second + ""
              return <div className="panel_time_box">
                {hourNum.split('').map((el, index) => {
                  return <span className='panel_time_num' key={index}>{el}</span>
                })}
                <span>:</span>
                {minute.split('').map((el, index) => {
                  return <span className='panel_time_num' key={index}>{el}</span>
                })}
                <span>:</span>
                {second.split('').map((el, index) => {
                  return <span className='panel_time_num' key={index}>{el}</span>
                })}
              </div>
            }}
            countdownOver={() => store.updateIndex()}
          />
        </div>
        <Button className="iknow" onClick={this.close}></Button>
        <Button className="close" onClick={this.close}></Button>
      </div>
    </>);
  }
}
export default RedPackCountPanel;
