'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './index.less';
import store from '../../store/store';
import { Button } from '@grace/ui';
import { _asyncThrottle } from "../../utils/utils";
import { ModalCtrl } from "@/core/ctrls/ModalCtrl";
import AnswerPrizePanel from "@/panels/answerPrizePanel/index";
import API from '@/api';
import taskStore from '@/store/task';

@observer
class AnswerPanel extends React.Component {
  constructor(props) {
    super(props);
    this.startId = null;
    this.state = {
      qsInfo: {},
      correctAnswers: [],
      selAnswer: null
    }
  }
  componentDidMount() {
    this.getQuestion();
  }
  getQuestion = async () => {
    const { success } = await API.queryQS();
    if (success) {
      this.startQuestion();
    }
  }
  startQuestion = async () => {
    const { success, data } = await API.startQS();
    if (success) {
      this.startId = data.startId;
      this.getQsDesc();
    }
  }

  getQsDesc = async () => {
    const { success, data } = await API.getQS({
      startId: this.startId
    });
    if (success) {
      this.setState({
        qsInfo: data
      })
    }
  }
  async submit(index) {
    if (this.state.selAnswer) return;
    const { success, data } = await API.submitQS({
      startId: this.startId,
      answer: index + ''
    })
    this.setState({
      selAnswer: index + ''
    })
    if (success) {
      if (data.answer) {
        this.setState({
          correctAnswers: data.answer?.correctAnswers || []
        })
      }
      this.completeQS();
    }
  }
  async completeQS() {
    const { success, data } = await API.completeQS({
      startId: this.startId,
    })
    if (success) {
      setTimeout(() => {
        this.handleClose();
        ModalCtrl.showModal(AnswerPrizePanel, data.options[0] || {});
      }, 2000)
      taskStore.queryTaskInfo();
    }
  }

  handleClose = _asyncThrottle(() => {
    ModalCtrl.closeModal()
  })

  render() {
    const qsInfo = this.state.qsInfo || {};
    const correctAnswers = this.state.correctAnswers || [];
    const selAnswer = this.state.selAnswer;
    return (
      <div className="answerPanel modal_center">
        <span className="bg"></span>
        <div className='question-title'>{qsInfo.content || ''}</div>
        <div className='answer-con'>
          {(qsInfo.answers || []).map((el, index) => {
            return <div className={`answer-item ${selAnswer === index + '' && correctAnswers.length > 0 && !correctAnswers.includes(index + '') ? 'error' : ''} ${correctAnswers.includes(index + '') ? 'correct' : ''}`} key={index} onClick={_asyncThrottle(() => {
              this.submit(index)
            })}>{el}
              {selAnswer === index + '' && correctAnswers.length > 0 && !correctAnswers.includes(index + '') && <span className='error-icon'></span>}
              {correctAnswers.includes(index + '') && <span className='correct-icon'></span>}
            </div>
          })}
        </div>
        <Button className="close" onClick={this.handleClose} />
      </div>
    );
  }
}
export default AnswerPanel;
