import Panel from "../../Module/Panel";
import { _decorator, Button, Node } from "cc";
import { observer, render } from "../store/decorators";

const {ccclass, property} = _decorator;

@observer
@ccclass('BackPanel')
export default class BackPanel extends Panel {

    static bundle: string = "BackPanel";
    static skin = "BackPanel";
    // static group = "BackPanel";

    @property(Node) closeBtn: Node = null;
    @property(Node) yes: Node = null;
    @property(Node) no: Node = null;

    onLoad() {
        this.closeBtn.on(Button.EventType.CLICK, this.clickClose);
        this.no.on(Button.EventType.CLICK, this.clickClose);
        this.yes.on(Button.EventType.CLICK, this.clickYes);
    }

    clickClose = () => {
        this.hidePanel();
    }

    clickYes = () => {
    }

}
