import { _decorator, Button, Node } from 'cc';
import Scene from "db://assets/Module/Scene";
import { MainGame } from "./MainGame/MainGame";
import { changeScene, showPanel } from "db://assets/Module/UIFast";
import store from "../store/store";
import { observer, render } from "../store/decorators";
import { _asyncThrottle } from "../Utils/Utils";
import RankPanel from "../Panels/RankPanel";
import { UIMgr } from "../../Module/UIMgr";

const { ccclass, property } = _decorator;

@observer
@ccclass('HomeScene')
export class HomeScene extends Scene {

    static bundle: string = "HomeScene";
    static skin: string = "HomeScene";
    // static group: string[] = ["HomeScene"];


    @property(Node) startBtn: Node = null;
    @property(Node) ruleBtn: Node = null;
    @property(Node) rankBtn: Node = null;
    @property(Node) backBtn: Node = null;

    onLoad() {
        this.startBtn.on(Button.EventType.CLICK, this.clickStart, this);
        this.ruleBtn.on(Button.EventType.CLICK, this.clickRule, this);
        this.rankBtn.on(Button.EventType.CLICK, this.clickRank, this);
        this.backBtn.on(Button.EventType.CLICK, this.clickBack, this);
    }

    async start() {

        await store.updateIndex();

        UIMgr.ins.preloadScene(MainGame);

    }

    @render
    render() {
        // const {} = store.homeInfo || {};
    }

    clickStart = _asyncThrottle(async () => {
        changeScene(MainGame);

    });

    clickRule = _asyncThrottle(async () => {
        // showPanel(RulePanel);
    });

    clickRank = _asyncThrottle(() => {
        showPanel(RankPanel);
    });

    clickBack = _asyncThrottle(() => {
    });

}

