'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './bindpop.less';
import { _throttle, windowJumpUrl } from '@src/utils/utils';
import modalStore from '@src/store/modal';
import { Button } from '../Button';

@observer
class Bindpop extends React.Component {
  constructor(props) {
    super(props);
  }

  /** 关闭弹窗 */
  closeDialog = _throttle(() => {
    modalStore.closePop();
  })

  /** 去绑定 */
  toBind = _throttle(() => {
    modalStore.closePop();
    windowJumpUrl(CFG.bindUrl);
  })

  render() {
    return (
      <div className="bindpop modal_center">
        <span className="bg"></span>
        <Button className="bind_btn" onClick={this.toBind}></Button>
        <Button className="close" onClick={this.closeDialog}></Button>
      </div>
    );
  }
}
export default Bindpop;
