'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './rulepop.less';
import store from '@src/store';
import { Button } from '../Button';
import modalStore from '@src/store/modal';
import { _throttle } from '@src/utils/utils';
import { sensorMdClick, sensorMdExpouse } from '@src/utils/sensorMd';

@observer
class Rulepop extends React.Component {
  constructor(props) {
    super(props);
  }
  async componentDidMount() {
    sensorMdExpouse("PopupExpouse", { pageName: "活动规则弹窗" });
    await store.initRule();
  }

  closeHandle = _throttle(() => {
    sensorMdClick("PopupClick", { pageName: "活动规则弹窗点击", buttonName: "关闭" });
    modalStore.closePop();
  });

  render() {
    return (
      <div className="rulepop modal_center">
        <span className="bg"></span>
        <div className="content" dangerouslySetInnerHTML={{ __html: store?.ruleInfo }}></div>
        <Button className="close" onClick={this.closeHandle}></Button>
      </div>
    );
  }
}
export default Rulepop;
