import React, { Component } from "react";
import Rulepop from "../components/rulepop/rulepop";
import Taskpop from "../components/taskpop/taskpop";
import Drawfailpop from "../components/drawfailpop/drawfailpop";
import Drawchancepop from "../components/drawchancepop/drawchancepop";
import Drawsucpop from "../components/drawsucpop/drawsucpop";
import './modal.less';
import { observer } from 'mobx-react';
import modalStore from '../store/modal';
import { toJS } from 'mobx';
import Focuspop from "@src/components/focuspop/focuspop";
import Bindpop from "@src/components/bindpop/bindpop";
import LongImgPop from "@src/components/longImgPop/longImgPop";
import LongImgPop2 from "@src/components/longImgPop2/longImgPop2";
import Videopop from "@src/components/videopop/videopop";
import ExitPop from "@src/components/exitPop/exitPop";
import EventPanel from "@src/components/EventPanel/EventPanel";
import FundsPanel from "@src/components/FundsPanel/FundsPanel";
import ReviewPanel from "@src/components/ReviewPanel/ReviewPanel";
import BackPanel from "@src/components/BackPanel/BackPanel";
/**
 * 弹窗配置
*/

export const cfg = {
  Drawsucpop: Drawsucpop,
  Drawchancepop: Drawchancepop,
  Drawfailpop: Drawfailpop,
  Taskpop: Taskpop,
  Rulepop: Rulepop,
  Focuspop,
  Bindpop,
  ExitPop,
  LongImgPop,
  LongImgPop2,
  Videopop,
  EventPanel,
  FundsPanel,
  ReviewPanel,
  BackPanel,
};

@observer
class Modal extends Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {}

  render() {
    const list = toJS(modalStore.popList);

    if (!list.length) {
      // TODO:此处根据需要自行修改
      // document.body.style.overflow='auto';
      return <section></section>;
    }

    let PopUpMulti, popUpMultiData;

    if (list.length > 1 && list[list.length - 1].isMulti == true) {
      const popObj2 = list[list.length - 1];
      PopUpMulti = cfg[popObj2.key];
      popUpMultiData = popObj2.data;
    }

    const popObj = list[0];
    const PopUp = cfg[popObj.key];
    const popData = popObj.data;

    if (PopUp || PopUpMulti) {
      document.body.style.overflow = 'hidden';
    }

    return <section className="modal-hoc-bg" style={{
      zIndex: modalStore.popList.length ? 1000 : -1,
      display: modalStore.popList.length ? 'block' : 'none'
    }}>
      {PopUp && <PopUp popData={popData} />}
      {PopUpMulti && <section className="modal-hoc-bg" style={{
        zIndex: modalStore.popList.length ? 1000 : -1,
        display: modalStore.popList.length ? 'block' : 'none'
      }}><PopUpMulti popData={popUpMultiData} />
      </section>}
    </section>;
  }

}

export default Modal;
