'use strict';

import React from 'react';
import {observer} from 'mobx-react';
import './resultpage.less';
import store from '@src/store';
import {Button} from '@src/components/Button';
import {_throttle} from '@src/utils/utils';
import modalStore from '@src/store/modal';
import {PAGE_MAP, ROLE_MAP} from '@src/utils/constants';
import shareStore from '@src/store/share';
import {sensorMdClick, sensorMdExpouse} from '@src/utils/sensorMd';
import {hideLoading, showLoading} from '@spark/ui';
import {htmlShot} from '@spark/utils';

@observer
class Resultpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      poster: null,
    };
  }

  async componentDidMount() {
    sensorMdExpouse("activityPage", {pageName: "结果页", follow_action: 3});
    showLoading();
    await this.doCreatePoster();
    this.pageRef?.scrollTo(0, 240 * window.remScale);
  }

  /** 合成海报 */
  doCreatePoster = async () => {
    setTimeout(async () => {
      const url = await htmlShot(this.shotRef)
      this.setState({poster: url})
      hideLoading()
    }, 500);
  };


  doShare = _throttle(() => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "分享人设"});
    shareStore.doShare();
  })
  goDraw = _throttle(() => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "立即抽奖"});
    store.changePage(PAGE_MAP.DRAW_PAGE, {is_from: 'result'});
  })
  // 查看产品详情
  openProduct = _throttle(() => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "点击查看"});
    modalStore.pushPop("LongImgPop2", {imgUrl: ROLE_MAP[store.roleId].productLink})
  })

  backHandle = _throttle(() => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "返回"});
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const {poster} = this.state;

    const {score} = this.props;

    return <div className="Resultpage" ref={r => this.pageRef = r}>
      <div className="bg"/>
      <div className="poster" ref={r => this.shotRef = r}>
        <span className="posterBg"></span>
      </div>
      {poster && <img className="poster_img" src={poster} style={{opacity: 0}} alt=""/>}

      <Button className="product_btn" onClick={this.openProduct}></Button>

      <span className="tips">长按保存海报分享</span>
      <Button className="share_btn" onClick={this.doShare}/>
      <Button className="draw_btn" onClick={this.goDraw}/>
    </div>;
  }
}

export default Resultpage;
