import React from "react";
import {observer} from "mobx-react";
import "./EventPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import modalStore from "@src/store/modal";
import {_asyncThrottle} from "@src/utils/utils";

@observer
class EventPanel extends React.Component {

  componentDidMount() {
  }

  onClick = _asyncThrottle(async () => {
    const {event, call} = this.props.popData;
    await call?.();
    modalStore.closePop();
  });

  render() {
    const {event, call} = this.props.popData;

    // 当前题目
    return <div className="EventPanel modal_center" onClick={this.onClick}>
      <SvgaPlayer className="effect" src={RES_PATH + "svga/2输出弹窗氛围.svga"}/>
      <img className="bg" src={event.bg}/>
      <div className="txt" dangerouslySetInnerHTML={{__html: event.txt}}/>
      <div className="next">点击屏幕继续游戏</div>
    </div>;
  }
}

export default EventPanel;
