/**
 * 活动主入口
 */
import React, { Component } from "react";
import ReactDOM from "react-dom";
import { observer } from "mobx-react";
import "./app.less";
import store from "./store/index";
import Modal from "./modal/modal";
import "./utils/checkwebp"; // webp检查
import MD from "../MD"; // 埋点
MD();

// 此处为spark-cli动态生成
import LoadingDemo from "@src/pages/LoadingDemo/LoadingDemo";
import Homepage from "./pages/homepage/homepage";
import { PAGE_MAP } from "./utils/constants";
import { ensureDomain, domain } from '@spark/dbdomain';
import Answerpage from "./pages/answerpage/answerpage";
import Prizepage from "./pages/prizepage/prizepage";
import Drawpage from "./pages/drawpage/drawpage";
import Resultpage from "./pages/resultpage/resultpage";
import MiddlePageNew from "@src/pages/middlePageNew/middlePageNew";
import { loadOneFont } from "./utils/preload1.3";
import LifeSettingPage from "@src/pages/LifeSettingPage/LifeSettingPage";
import {RES_PATH} from "../sparkrc";

/**
 * 所有页面场景
 */
const pageMap = {
  [PAGE_MAP.LOADING_PAGE]: <LoadingDemo />,
  [PAGE_MAP.HOME_PAGE]: <Homepage />,
  [PAGE_MAP.QUES_PAGE]: <Answerpage />,
  [PAGE_MAP.PRIZE_PAGE]: <Prizepage />,
  [PAGE_MAP.DRAW_PAGE]: <Drawpage />,
  [PAGE_MAP.RESU_PAGE]: <Resultpage />,
  [PAGE_MAP.MID_PAGE]: <MiddlePageNew />,
  [PAGE_MAP.LIFE_SETTING_PAGE]: <LifeSettingPage />,
};

@observer
class App extends Component {
  async componentDidMount() {
    // 获取前端开发配置，依据项目需要，酌情添加 ！！！
    if (store.curPage !== PAGE_MAP.MID_PAGE) {
      await store.getFrontVariable();
      // 获取动态域名
      await ensureDomain();
      CFG.domain = domain || window.location.origin;
      CFG.index = CFG.domain + CFG.index;
    }
    this.loadFonts();
  }

  /**
   * 加载特殊字体包
   */
  loadFonts = async() => {
    await loadOneFont(
      RES_PATH + "font/KingnamBobo.ttf",
      "KingnamBobo"
    );
  };

  render() {
    const { curPage, pageData } = store;
    return (
      <>
        {{ ...pageMap[curPage], props: { ...pageData } }}
        <Modal />
      </>
    );
  }
}

ReactDOM.render(<App />, document.getElementById("root"));
