import React from "react";
import {observer} from "mobx-react";
import "./BackPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import {Button} from "@src/components/Button";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";
import modalStore from "@src/store/modal";
import { sensorMdClick, sensorMdExpouse } from "@src/utils/sensorMd";

@observer
class BackPanel extends React.Component {

  componentDidMount() {

  }

  componentWillUnmount() {
    clearTimeout(this.t);
  }

  clickCancel = () => {
    modalStore.closePop();
  }

  clickOk = () => {
    modalStore.closePop();
    store.changePage(PAGE_MAP.HOME_PAGE);
  }

  render() {
    // 当前题目
    return <div className="BackPanel modal_center">
      <div className="bg"/>
      <Button className="cancel" onClick={this.clickCancel}/>
      <Button className="ok" onClick={this.clickOk}/>
      <Button className="close" onClick={this.clickCancel}/>
    </div>;
  }
}

export default BackPanel;
