'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './longImgPop.less';
import modalStore from '@src/store/modal';
import { _throttle, windowJumpUrl } from '@src/utils/utils';
import { Button } from '../Button';

@observer
class LongImgPop extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      isFinish: false,
      countdownTime: 5, // 单位s
    }
    this.timer = ''
  }

  componentDidMount() {
    this.startInterval()
  }

  componentWillUnmount() {
    if (this.timer) clearInterval(this.timer)
  }

  /** 开始倒计时 */
  startInterval = () => {
    if (this.timer) clearInterval(this.timer)
    this.timer = setInterval(async () => {
      if (this.state.countdownTime === 0) {
        this.setState({
          isFinish: true
        })
        clearInterval(this.timer)
        this.timer = ''
        // 完成任务
        const { taskSucCb } = this.props?.popData || {}
        taskSucCb && taskSucCb()
        return
      }
      this.setState({
        countdownTime: this.state.countdownTime - 1,
      })
    }, 1000);
  }

  /** 关闭当前页面 */
  closeHandle = () => {
    modalStore.closePop();
  }

  goServeice = _throttle(() => {
    windowJumpUrl(CFG.serviceJumpUrl)
  });

  render() {
    const { imgUrl } = this.props.popData || {}
    const { isFinish, countdownTime } = this.state
    return (
      <div className="longImgPop">
        <img src={imgUrl} alt="" className="mainImg" />
        <Button className="back_home" onClick={this.closeHandle}></Button>
        {!isFinish && <span className='countdown'>{`${countdownTime}s`}</span>}
        <Button className="service_btn" onClick={this.goServeice}></Button>
      </div>
    );
  }
}

export default LongImgPop;
