'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './longImgPop2.less';
import modalStore from '@src/store/modal';
import { _throttle } from '@src/utils/utils';
import { Button } from '../Button';

@observer
class LongImgPop2 extends React.Component {
  constructor(props) {
    super(props);
  }

  /** 关闭当前页面 */
  closeHandle = () => {
    modalStore.closePop();
  }

  render() {
    const { imgUrl } = this.props.popData || {}
    return (
      <div className="longImgPop2">
        <img src={imgUrl} alt="" className="mainImg" />
        <Button className="back_home" onClick={this.closeHandle}></Button>
      </div>
    );
  }
}

export default LongImgPop2;
