"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./drawfailpop.less";
import { _throttle } from "@src/utils/utils";
import modalStore from "@src/store/modal";
import { sensorMdClick, sensorMdExpouse } from "@src/utils/sensorMd";
import { Button } from "../Button";

@observer
class Drawfailpop extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    sensorMdExpouse("PopupExpouse", { pageName: "守护人生活动-未中奖弹窗" });
  }

  knowHandle = _throttle(() => {
    sensorMdClick("PopupClick", { pageName: "守护人生活动-未中奖弹窗", buttonName: "我知道了" });
    modalStore.closePop();
  });

  render() {
    return (
      <div className="drawfailpop modal_center">
        <span className="bg"></span>
        <span className="text">别灰心，明天再试试吧～</span>
        <Button className="btn md22" onClick={this.knowHandle}></Button>
        <span
          className="close"
          onClick={() => {
            sensorMdClick("PopupClick", { pageName: "守护人生活动-未中奖弹窗", buttonName: "关闭" });
            modalStore.closePop();
          }}></span>
      </div>
    );
  }
}
export default Drawfailpop;
