import React from 'react';
import videojs from 'video.js';
import './VideoPlayer.less'

export default class VideoPlayer extends React.Component {
    constructor(props) {
        super(props);
    }

    componentDidMount() {
        this.player = videojs(this.videoNode, this.props, () => {
            videojs.log('onPlayerReady', this);
            this.props.videoRefCb(this.player)
        });
    }

    // Dispose the player when the component will unmount
    componentWillUnmount() {
        if (this.player) {
            this.player.dispose();
        }
    }

    render() {
        return (
            <div data-vjs-player style={this.props.style}>
                <video
                    ref={node => this.videoNode = node}
                    className="video-js"
                ></video>
            </div>
        );
    }
}
