'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './exitPop.less';
import modalStore from '@src/store/modal';
import { _throttle } from '@src/utils/utils';
import { Button } from '../Button';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';

@observer
class ExitPop extends React.Component {
  constructor(props) {
    super(props);
  }

  /** 确认退出 */
  exitHandle = () => {
    modalStore.closePop();
    store.changePage(PAGE_MAP.HOME_PAGE)
  }

  /** 关闭 */
  closeHandle = () => {
    modalStore.closePop();
  }

  render() {
    return (
      <div className="exitPop modal_center">
        <span className="bg"></span>
        <span className="text">退出后将结束本次测试，<br />参与机会不作返还</span>
        <Button className="cancel_btn" onClick={this.closeHandle}></Button>
        <Button className="confirm_btn" onClick={this.exitHandle}></Button>
        {/* <Button className="close" onClick={this.closeHandle}></Button> */}
      </div>
    );
  }
}

export default ExitPop;
