import React from 'react';
import { observer } from 'mobx-react';
import './focuspop.less';
import { _throttle } from '@src/utils/utils';
import modalStore from '@src/store/modal';
import { Button } from '../Button';

@observer
class Focuspop extends React.Component {
  constructor(props) {
    super(props);
  }

  /** 关闭弹窗 */
  closeDialog = _throttle(() => {
    modalStore.closePop();
  })

  render() {
    return (
      <div className="focuspop modal_center">
        <span className="bg"></span>
        <img className="qrcode_bg" src={CFG.codeUrl} />
        <Button className="close" onClick={this.closeDialog}></Button>
      </div>
    );
  }
}
export default Focuspop;
