import React from "react";
import {observer} from "mobx-react";
import "./EventPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import modalStore from "@src/store/modal";
import {_asyncThrottle} from "@src/utils/utils";

@observer
class EventPanel extends React.Component {

  componentDidMount() {
  }

  onClick = _asyncThrottle(async () => {
    const {event, call} = this.props.popData;
    await call?.();
    modalStore.closePop();
  });

  clickBanner = _asyncThrottle(async () => {
    const {event} = this.props.popData;

    if (!event.banner) return;

    modalStore.pushPop("LongImgPop2", {imgUrl: event.banner.link})
  });

  render() {
    const {event, call} = this.props.popData;

    // 当前题目
    return <div className="EventPanel modal_center">
      <SvgaPlayer className="effect" src={RES_PATH + "svga/2输出弹窗氛围.svga"}/>
      <img className="bg" src={event.bg} onClick={this.onClick}/>
      <div className="txt" onClick={this.onClick} dangerouslySetInnerHTML={{__html: event.txt}}/>
      {event.banner && <div className="banner" style={{
        backgroundImage: `url(${event.banner.img})`,
      }} onClick={this.clickBanner}></div>}
      <div className="next" onClick={this.onClick}>点击屏幕继续游戏</div>
    </div>;
  }
}

export default EventPanel;
