import API from "@src/api";
import {
  setCookieId
} from "@src/api/utils";


/**
 * 普通跳转客服
 * 注意:小程序需要额外增加业务域名 https://duiba.qiyukf.com/
 */
export function jumpService() {
  location.href = location.origin + '/faq/index'
}


export function appJump(url, hideNavbar = false, data = {}) {
  API.tempSaveCookie().then((res) => {
    if (res?.data) {
      localStorage.setItem("db_temp_cookie", res.data);
      // setCookieId(res.data);
    }
  }).finally(() => {

    // app对应跳转方法
    window.MarsJSBridge.invoke("pushPage", {
      uri: url,
      data,
      pageParams: {
        hideNavbar,
      }
    });

  });
}
