import React from "react";
import {observer} from "mobx-react";
import "./answerpage.less";
import {_asyncThrottle, _throttle, waitTime} from "@src/utils/utils";
import {Button} from "@src/components/Button";
import {QuestionCfg} from "@src/pages/answerpage/QuestionCfg";
import classNames from "classnames";
import modalStore from "@src/store/modal";

@observer
class Answerpage extends React.Component {
  state = {
    funds: 0,
    quesIndex: 0,
    chooseIndex: null,
  };

  componentDidMount() {
    this.setState({
      funds: this.props.funds,
    })
  }

  clickItem(index) {
    this.setState({
      chooseIndex: index,
    });
  }


  goNext(money) {

    if (this.state.quesIndex == 5) {

      return;
    }

    this.setState({
      chooseIndex: null,
      quesIndex: this.state.quesIndex + 1,
      funds: this.state.funds + money,
    });
  }

  clickNext = () => {
    const {quesIndex, chooseIndex, funds} = this.state;

    const {event} = QuestionCfg[quesIndex].answer[chooseIndex];

    modalStore.pushPop("EventPanel", {
      event,
      call: () => {
        this.goNext(event.money);
      }
    });
  }

  render() {
    const {quesIndex, chooseIndex, funds} = this.state;

    const {stage, bg, titleImg, answer} = QuestionCfg[quesIndex];

    // 当前题目
    return <div className="answerpage modal_center">
      <div
        className="bg"
        style={{
          backgroundImage: `url(${bg})`,
        }}
      />

      <div className="stage">{stage}</div>

      <div className="fundsArea">
        <div className="funds">当前资金：<span>{funds}</span>万</div>
      </div>

      <div className="quesArea">
        <div className="queIndex">
          <span>{quesIndex + 1}</span>
          <text>/</text>
          6
        </div>
        <div className="questionArea">
          <img
            src={titleImg}
            style={{
              transformOrigin: 'top left',
              transform: `scale(${window.remScale}) translateY(50%)`
            }}
          />
        </div>

        <div className="answerArea">
          {answer.map((item, index) => {
            const cls = classNames(
              "answerItem",
              {
                active: index === chooseIndex,
              }
            );
            return <div
              className={cls}
              onClick={this.clickItem.bind(this, index)}
            >{item.txt}</div>
          })}
        </div>
      </div>
      <Button className="confirm" onClick={this.clickNext}/>
    </div>;
  }
}

export default Answerpage;
