import React from "react";
import {observer} from "mobx-react";
import "./ReviewPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import {Button} from "@src/components/Button";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";
import modalStore from "@src/store/modal";

@observer
class ReviewPanel extends React.Component {
  state = {
    itemsVisible: new Array(5).fill(false)
  };

  componentDidMount() {
    // 延迟启动动画
    setTimeout(() => {
      this.startAnimation();
    }, 200);
  }

  startAnimation = () => {
    // 逐个显示 item
    this.state.itemsVisible.forEach((_, index) => {
      setTimeout(() => {
        this.setState(prevState => ({
          itemsVisible: prevState.itemsVisible.map((visible, i) => 
            i === index ? true : visible
          )
        }));
      }, index * 300); // 每个 item 延迟 300ms
    });
  };

  clickNext = () => {
    modalStore.closePop();
    store.changePage(PAGE_MAP.QUES_PAGE, {funds: this.props.popData.funds});
  }

  render() {
    const {funds} = this.props.popData;
    const {itemsVisible} = this.state;

    // 当前题目
    return <div className="ReviewPanel modal_center" onClick={this.clickNext}>
      <SvgaPlayer className="effect" src={RES_PATH + "svga/2输出弹窗氛围.svga"}/>
      <div className="bg"/>
      <div className="items-container">
        {
          new Array(5).fill(1).map((item, index) => {
            return (
              <div 
                key={index}
                className={`item item${index % 2} ${itemsVisible[index] ? 'item-visible' : ''}`} 
                style={{
                  top: (217 + index * 250) * remScale,
                }}
              >
                <div className="txt">11岁：家庭纽带</div>
              </div>
            );
          })
        }
      </div>
      <div className="tip">点击屏幕继续测试</div>
    </div>;
  }
}

export default ReviewPanel;
