'use strict';

import React from 'react';
import {observer} from 'mobx-react';
import './resultpage.less';
import store from '@src/store';
import {Button} from '@src/components/Button';
import {_throttle} from '@src/utils/utils';
import modalStore from '@src/store/modal';
import {PAGE_MAP, ROLE_MAP} from '@src/utils/constants';
import shareStore from '@src/store/share';
import {sensorMdClick, sensorMdExpouse} from '@src/utils/sensorMd';
import {hideLoading, showLoading} from '@spark/ui';
import {htmlShot} from '@spark/utils';
import {RES_PATH} from "../../../sparkrc";

@observer
class Resultpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      poster: null,
    };
  }

  async componentDidMount() {
    sensorMdExpouse("activityPage", {pageName: "结果页", follow_action: 3});
    showLoading();
    await this.doCreatePoster();
    this.pageRef?.scrollTo(0, 240 * window.remScale);
  }

  /** 合成海报 */
  doCreatePoster = async () => {
    setTimeout(async () => {
      const url = await htmlShot(this.shotRef)
      this.setState({poster: url})
      hideLoading()
    }, 500);
  };


  doShare = _throttle(() => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "分享结果"});
    shareStore.doShare();
  })
  goDraw = _throttle(() => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "去抽奖"});
    store.changePage(PAGE_MAP.DRAW_PAGE, {is_from: 'result'});
  })
  // 查看产品详情
  openProduct = _throttle((link) => {
    sensorMdClick("activityClick", {pageName: "结果页", buttonName: "去查看"});
    modalStore.pushPop("LongImgPop2", {imgUrl: link})
  })

  backHandle = _throttle(() => {
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const {poster} = this.state;

    const {score = 1, funds} = this.props;

    const info = {
      1: {
        bg: RES_PATH + "resultPage/负债.jpg",
        color: "#0075f5",
        link: "//yun.duiba.com.cn/polaris/5%E3%80%81%E5%AE%89%E4%BA%AB2025%E9%95%BF%E5%9B%BE.c644f11434fe71c7bdead8267757240452886f5c.jpg",
        poster: RES_PATH + "resultPage/poster/负债.jpg",
      },
      2: {
        bg: RES_PATH + "resultPage/小康.jpg",
        color: "#ed4300",
        link: "//yun.duiba.com.cn/polaris/%E9%91%AB%E7%A6%A7%E5%B9%B4%E5%B9%B4.bd49c5dc528fce77e8c9f0690f779746d99089d9.jpg",
        poster: RES_PATH + "resultPage/poster/小康.jpg",
      },
      3: {
        bg: RES_PATH + "resultPage/中产.jpg",
        color: "#7c28ec",
        link: "//yun.duiba.com.cn/polaris/%E8%9B%AE%E5%A5%BD%E4%BA%BA%E7%94%9F%E4%BC%A0%E4%B8%96%E7%89%88.867da0febb90ed822ee5180f0d7c216dba306b3b.jpg",
        poster: RES_PATH + "resultPage/poster/中产.jpg",
      },
      4: {
        bg: RES_PATH + "resultPage/富有.jpg",
        color: "#f58400",
        link: "//yun.duiba.com.cn/polaris/%E8%9B%AE%E5%A5%BD%E7%9A%84%E4%BA%BA%E7%94%9F%E8%87%B3%E5%B0%8A%E7%89%88.a930a2718ab9c74d0c6c60f86554b3dc1cb9ea78.jpg",
        poster: RES_PATH + "resultPage/poster/富有.jpg",
      },
    }[score]

    return <div className="Resultpage" ref={r => this.pageRef = r}>
      <div className="resBg" style={{backgroundImage: `url(${info.bg})`}}/>
      <div className="poster" ref={r => this.shotRef = r}>
        <div className="posterBg" style={{backgroundImage: `url(${info.poster})`}}/>
        <div
          className="posterFunds"
          style={{color: info.color}}
        >
          {funds * 10000}<span>元</span>
        </div>
        <img src={CFG.codeUrl} className="qrCode"/>
      </div>

      <div
        className="funds"
        style={{color: info.color}}
      >
        {funds * 10000}<span>元</span>
      </div>
      <span className="tips">长按保存海报分享</span>

      {poster && <img className="poster_img" src={poster} style={{opacity: 0}} alt=""/>}

      <Button className="back_btn" onClick={() => store.changePage(PAGE_MAP.HOME_PAGE)}/>
      <Button className="product_btn" onClick={() => this.openProduct(info.link)}/>
      <Button className="share_btn md18" onClick={this.doShare}/>
      <Button className="draw_btn md17" onClick={this.goDraw}/>
    </div>;
  }
}

export default Resultpage;
