import React from "react";
import {observer} from "mobx-react";
import "./EventPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import modalStore from "@src/store/modal";
import {_asyncThrottle} from "@src/utils/utils";
import { miniGoUrl } from "@src/utils/share";

@observer
class EventPanel extends React.Component {

  componentDidMount() {
    this.t = setTimeout(() => {
      this.onClick();
    }, 10000);
  }

  componentWillUnmount() {
    clearTimeout(this.t);
  }

  onClick = _asyncThrottle(async () => {
    const {event, call} = this.props.popData;
    await call?.();
    modalStore.closePop();
  });

  clickBanner = _asyncThrottle(async () => {
    const {event} = this.props.popData;

    if (!event.banner) return;

    if (event.banner.link.indexOf("//") >= 0) {
      modalStore.pushPop("LongImgPop2", {imgUrl: event.banner.link})
    } else {
      miniGoUrl(event.banner.link);
    }
  });

  render() {
    const {event, call} = this.props.popData;

    // 当前题目
    return <div className="EventPanel modal_center">
      <SvgaPlayer className="effect" src={RES_PATH + "svga/2输出弹窗氛围.svga"}/>
      <img className="bg" src={event.bg} onClick={this.onClick}/>
      <div className="txt" onClick={this.onClick} dangerouslySetInnerHTML={{__html: event.txt}}/>
      {event.banner && <div className="banner" style={{
        backgroundImage: `url(${event.banner.img})`,
      }} onClick={this.clickBanner}></div>}
      <div className="next" onClick={this.onClick}>点击屏幕继续游戏</div>
    </div>;
  }
}

export default EventPanel;
