import MD from 'spark-utils/out/md/index.js';

import { logClick } from "@spark/utils/src-js/md";
import { jsonp } from "@spark/api-base";
let appId = CFG.appID;
const dcm = '202.' + CFG.projectId + '.0.0';
const domain = '';
const dom = `${CFG.channel}.0.0.0`;

const MDList = Array.from({ length: 30 }).map((_, index) => {
  return {
    ele: `.md${index + 1}`,
    data: {
      dpm: `${appId}.110.${index + 1}.1`,
      dcm,
      domain,
      appId,
      dom
    },
    once: false
  };
})

export default () =>
  MD({
    show: MDList, // 曝光
    click: MDList // 点击
  });
export function logExposure(params) {
  jsonp("/exposure/standard", params);
}
export function handleLogExposure(id, id2 = 1) {
  logExposure({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
    dom
  });
}
export function handleLogClick(id, id2 = 1) {
  logClick({
    dpm: `${appId}.110.${id}.${id2}`,
    dcm,
    domain,
    appId,
    dom
  });
}
