"use strict";

import React from "react";
import { observer } from "mobx-react";
import "./homepage.less";
import { _throttle } from "@src/utils/utils";
import { Button } from "@src/components/Button";
import modalStore from "@src/store/modal";
import store from "@src/store";
import { Toast } from "@spark/ui";
import { onInitShare } from "@src/utils/share";
import shareStore from "@src/store/share";
import { PAGE_MAP } from "@src/utils/constants";
import { pageLeave, sensorMdClick, sensorMdExpouse } from "@src/utils/sensorMd";
import { SvgaPlayer } from "@spark/svgaplayer";
import { RES_PATH } from "../../../sparkrc";

@observer
class Homepage extends React.Component {
  constructor(props) {
    super(props);
  }

  async componentDidMount() {
    await store.getHomeInfo();
    // 初始化神策埋点 得在首页接口之后 首页接口会打上业务员绑定标记
    await store.initSensorsMd();

    await onInitShare();
    // 初始化首页分享信息
    shareStore.initShareInfo();

    sensorMdExpouse("activityPage", { pageName: "守护人生活动首页", follow_action: 1 });
    pageLeave("守护人生活动首页", 5);
  }
  // 我的奖品
  goPrize = _throttle(() => {
    if (!store.checkActStatus(true)) return;
    sensorMdClick("activityClick", { pageName: "守护人生活动首页", buttonName: "奖品" });
    // store.changePage(PAGE_MAP.PRIZE_PAGE);
    location.href = CFG.prize;
  });
  doShare = _throttle(() => {
    if (!store.checkActStatus()) return;
    sensorMdClick("activityClick", { pageName: "守护人生活动首页", buttonName: "分享" });
    shareStore.doShare();
  });
  openRule = _throttle(() => {
    if (!store.checkActStatus(true)) return;
    sensorMdClick("activityClick", { pageName: "守护人生活动首页", buttonName: "规则" });
    modalStore.pushPop("Rulepop");
  });
  goDraw = _throttle(() => {
    if (!store.checkActStatus()) return;
    sensorMdClick("activityClick", { pageName: "守护人生活动首页", buttonName: "抽奖" });
    store.changePage(PAGE_MAP.DRAW_PAGE);
  });
  openTask = _throttle(() => {
    if (!store.checkActStatus()) return;
    sensorMdClick("activityClick", { pageName: "守护人生活动首页", buttonName: "做任务" });
    modalStore.pushPop("Taskpop", {
      refresh: () => store.getHomeInfo(),
    });
  });
  goTest = _throttle(() => {
    if (!store.checkActStatus()) {
      return;
    }
    const { leftGameTimes, rewardDailyFreeGameTimes } = store.homeInfo || {};
    sensorMdClick("activityClick", { pageName: "守护人生活动首页", buttonName: "开始测试" });
    if ((Number(leftGameTimes) || 0) > 0) {
      // 进入测试页
      store.startTest();
    } else {
      Toast("今日参与次数不足，明天再来吧～");
    }
  });

  render() {
    const { leftGameTimes, rewardDailyFreeGameTimes } = store.homeInfo || {};
    return (
      <div className="homepage modal_center">
        <span className="bg"></span>
        {/* <span className="content"></span> */}
        <div className="rule_prize"></div>
        <Button className="rule_btn md1" onClick={this.openRule}></Button>
        <Button className="ptize_btn md2" onClick={this.goPrize}></Button>
        <Button className="share_btn md3" onClick={this.doShare}></Button>
        <Button className="task_btn md6" onClick={this.openTask}></Button>
        <Button className="draw_btn md4" onClick={this.goDraw}></Button>
        <div className="main_btn md5" onClick={this.goTest}></div>
        <span className="test_times">剩余次数：{(Number(leftGameTimes) || 0)}</span>
        {/* <span className="title"></span> */}
        <SvgaPlayer className="home_svga" src={RES_PATH + "svga/home.svga"} />
      </div>
    );
  }
}
export default Homepage;
