const {AES, enc, mode, pad} = require("crypto-js");

const getOptions = (iv) => {
  return {
    iv: enc.Utf8.parse(iv),
    mode: mode.CBC,
    padding: pad.ZeroPadding,
  };
}

/** 加密 */
exports.AESEncrypt = (str, key, iv) => {

  const options = getOptions(iv);

  return AES.encrypt(str, enc.Utf8.parse(key), options).toString();
};
/** 解密 */
exports.AESDecrypt = (cipherText, key, iv) => {

  const options = getOptions(iv);

  return AES.decrypt(cipherText, enc.Utf8.parse(key), options)
    .toString(enc.Utf8)
    .trim()
    .replace(//g, '')
    .replace(//g, '')
    .replace(/\v/g, '')
    .replace(/\x00/g, '');
};

// const str = 'Hce05WTbYCxuSi20AN0d4wSifok5QjEZkNQ8EdQOkAJ1nuG8SVwZIMXXZNqtgsb8LYSp14xcCf+zybskOGjWpDD4BIURkZaSE5pynCESDGnpaavsah1sksKvno98jh9Cov6ZTLzeLVDzVKEtguV2XSgrVsud8hyohs9WLkObG1le3Ey29F3LFPB9fKOyI766ww0XvbjZ+l4nHYsuXxDlRg=='
// const txt = exports.AESDecrypt(str, "1c5f9cab3460e316", "cDOiBC1n2QrkAY2P");
// console.log(txt);
