import React from "react";
import {observer} from "mobx-react";
import "./LifeSettingPage.less";
import {_asyncThrottle, _throttle, waitTime} from "@src/utils/utils";
import {Button} from "@src/components/Button";
import classNames from "classnames";
import {SettingCfg} from "@src/pages/LifeSettingPage/SettingCfg";

@observer
class LifeSettingPage extends React.Component {
  state = {
    quesIndex: 0,
    chooseIndex: null,
  };

  componentDidMount() {
  }

  clickItem(index) {
    this.setState({
      chooseIndex: index,
    });
  }

  render() {
    const {quesIndex, chooseIndex} = this.state;

    const {titleImg, answer} = SettingCfg[quesIndex];

    // 当前题目
    return <div className="LifeSettingPage modal_center">
      <div className="bg"/>
      <div className="title"/>
      <img className="quesTitle" src={titleImg}/>

      <div className="answerArea">
        {answer.map((item, index) => {
          return <div className="answerItem" onClick={this.clickItem.bind(this, index)}>
            <img src={item.img}/>
            {chooseIndex === index && <div className="choose"/>}
          </div>
        })}
      </div>

      <Button className="confirm"/>
    </div>;
  }
}

export default LifeSettingPage;
