/*
 * @Author: super
 * @Date: 2021-01-20 14:08:27
 * @LastEditTime: 2021-01-20 14:53:39
 * @LastEditors: super
 * @Description:
 */
/**
 * 弹窗优先级 可以是负数， 不写默认是10， 数值越小，层级越高
 */
export const MODAL_INDEX = {
  // rank: 1,
};
/** 网络异常默认展示 */
export const DEFAULT_NET_ERROR = '网络异常，请稍后再试';

export const PAGE_MAP = {
  HOME_PAGE: "homePage",
  LOADING_PAGE: "loadingPage",
  DRAW_PAGE: "drawPage",
  PRIZE_PAGE: "prizePage",
  MID_PAGE: "midPage",
  QUES_PAGE: "quesPage",
  RESU_PAGE: "resultPage",
  LIFE_SETTING_PAGE: "LIFE_SETTING_PAGE",
};



/**
 * 渠道参数
 * 1.官微菜单栏 guanwei
 * 2.官微权益中心 quanyizhongxin
 * 3.寿险小程序 shouxian
 * 4.官微推文 tuiwen
 * 5.长航加油站 dingdong
 * 6.太好钉 taihaoding
 * 7.海报 haibao
 * 8.太好店小程序
 * 9.官微服务大厅
 * 10.集团app
 */
export const CHANNEL_PARAMS = {
  /** 官微菜单栏 */
  GW_MENU: "guanwei",
  /** 官微权益中心 */
  GW_EQUITY: "quanyizhongxin",
  /** 寿险小程序 */
  SHOUXIAN_MINI: "shouxian",
  /** 官微推文 */
  GW_TWEET: "tuiwen",
  /** 长航加油站（公众号） */
  CHANG_HANG: "dingdong",
  /** 太好钉 */
  THD: "taihaoding",
  /** 海报 */
  POSTER: "haibao",
  /** 太好店小程序 */
  THD_MINI: "taihaodian",
  /** 官微服务大厅 */
  FUWU: "fuwu",
  /** 集团app */
  APP: "app",
  /** 心意商城小程序 */
  XINYI: "xinyi",
  /** 年报活动 */
  NIANBAO: "nianbao",
  /** 订阅号 */
  DINGYUEHAO: "dingyuehao",
}


/** 神策 sysSourceName渠道参数 */
export const SYS_SOURCE_CHANNEL = {
  /** 官微菜单栏 */
  [CHANNEL_PARAMS.GW_MENU]: "官微",
  /** 官微权益中心 */
  [CHANNEL_PARAMS.GW_EQUITY]: "官微",
  /** 寿险小程序 */
  [CHANNEL_PARAMS.SHOUXIAN_MINI]: "官微",
  /** 官微推文 */
  [CHANNEL_PARAMS.GW_TWEET]: "官微",
  /** 长航加油站（公众号） */
  [CHANNEL_PARAMS.CHANG_HANG]: "个险",
  /** 太好钉 */
  [CHANNEL_PARAMS.THD]: "官微",
  /** 海报 */
  [CHANNEL_PARAMS.POSTER]: "官微",
  /** 太好店小程序 */
  [CHANNEL_PARAMS.THD_MINI]: "个险",
  /** 官微服务大厅 */
  [CHANNEL_PARAMS.FUWU]: "官微",
  /** 集团app */
  [CHANNEL_PARAMS.APP]: "官微",
  /** 心意商城小程序 */
  [CHANNEL_PARAMS.XINYI]: "官微",
  /** 年报活动 */
  [CHANNEL_PARAMS.NIANBAO]: "官微",
  /** 订阅号 */
  [CHANNEL_PARAMS.DINGYUEHAO]: "官微",
}

/** 神策 activitySource渠道参数 */
export const ACTIVITY_SOURCE_CHANNEL = {
  /** 官微菜单栏 */
  [CHANNEL_PARAMS.GW_MENU]: "官微菜单栏",
  /** 官微权益中心 */
  [CHANNEL_PARAMS.GW_EQUITY]: "官微权益中心",
  /** 寿险小程序 */
  [CHANNEL_PARAMS.SHOUXIAN_MINI]: "寿险小程序",
  /** 官微推文 */
  [CHANNEL_PARAMS.GW_TWEET]: "官微推文",
  /** 长航加油站（公众号） */
  [CHANNEL_PARAMS.CHANG_HANG]: "长航加油站",
  /** 太好钉 */
  [CHANNEL_PARAMS.THD]: "太好钉",
  /** 海报 */
  [CHANNEL_PARAMS.POSTER]: "海报",
  /** 太好店小程序 */
  [CHANNEL_PARAMS.THD_MINI]: "太好店小程序",
  /** 官微服务大厅 */
  [CHANNEL_PARAMS.FUWU]: "官微服务大厅",
  /** 集团app */
  [CHANNEL_PARAMS.APP]: "集团app",
  /** 心意商城小程序 */
  [CHANNEL_PARAMS.XINYI]: "心意商城小程序",
  /** 年报活动 */
  [CHANNEL_PARAMS.NIANBAO]: "年报活动",
  /** 订阅号 */
  [CHANNEL_PARAMS.DINGYUEHAO]: "订阅号",
}




/**
 * 活动状态(前端定义)
*/
export const ACT_STATUS = {
  /** 未开始 */
  NOT_START: '1',
  /** 进行中 */
  ING: '2',
  /** 已结束 */
  ENDED: '3',
}



/**
 * 活动状态toast
 */
export const ACT_STATUS_TOAST = {
  /** 未开始 */
  [ACT_STATUS.NOT_START]: '活动尚未开始',
  /** 已结束 */
  [ACT_STATUS.ENDED]: '活动已经结束',
}


/**
 * 任务code
*/
export const TASK_CODE = {
  /** 每日签到 */
  SIGN: 'sign',
  /** 浏览产品 */
  BROWSE_PRODUCT: 'browse_product',
  /** 完成留资 */
  THIRD_RETAIN: 'third_retain',
  /** 浏览视频 */
  BROWSE_VIDEO: 'browse_video',
  /** 浏览小程序页面 */
  BROWSE_MINI: 'browse_view_mini',
}

/**
 * 人设信息
 */
export const ROLE_MAP = {
  // a 传统守护者
  // b 社交组局王
  // c 狂热尝新党
  // d 佛系随性派
  // e 元气美食家
  a: {
    name: "传统守护者",
    productName: "太保岁优保（2024版）两全保险",
    productLink: "https://yun.duiba.com.cn/polaris/%E5%B2%81%E4%BC%98%E4%BF%9D.ea5556dd06efd9d929ad9d8617fa896d3164eae9.jpg",
  },
  b: {
    name: "社交组局王",
    productName: "太保蛮好人生（传世）终身寿险（分红型）",
    productLink: "https://yun.duiba.com.cn/polaris/%E8%9B%AE%E5%A5%BD%E4%BA%BA%E7%94%9F%E9%95%BF%E5%9B%BE.867da0febb90ed822ee5180f0d7c216dba306b3b.jpg",
  },
  c: {
    name: "狂热尝新党",
    productName: "太保爱心保（尊享2024）重大疾病保险",
    productLink: "https://yun.duiba.com.cn/polaris/%E7%88%B1%E5%BF%83%E4%BF%9D.ff0c1419a91b0be23d378eadd24e447ed621ce17.jpg",
  },
  d: {
    name: "佛系随性派",
    productName: "太保安享百万2025医疗保险（费率可调）",
    productLink: "https://yun.duiba.com.cn/polaris/5%E3%80%81%E5%AE%89%E4%BA%AB2025%E9%95%BF%E5%9B%BE.c644f11434fe71c7bdead8267757240452886f5c.jpg",
  },
  e: {
    name: "元气美食家",
    productName: "金生无忧2024（成人版)保险产品计划",
    productLink: "https://yun.duiba.com.cn/polaris/%E9%87%91%E7%94%9F%E6%97%A0%E5%BF%A7%EF%BC%88%E6%88%90%E4%BA%BA%EF%BC%89.46c5cd14e1c5e4bfe4cf6950bc407add9e5671ae.jpg",
  },
}
