import React from "react";
import {observer} from "mobx-react";
import "./answerpage.less";
import {_asyncThrottle, _throttle, waitTime} from "@src/utils/utils";
import {Button} from "@src/components/Button";
import {QuestionCfg} from "@src/pages/answerpage/QuestionCfg";
import classNames from "classnames";

@observer
class Answerpage extends React.Component {
  state = {
    quesIndex: 0,
    chooseIndex: null,
  };

  componentDidMount() {
  }

  clickItem(index) {
    this.setState({
      chooseIndex: index,
    });
  }

  render() {
    const {quesIndex, chooseIndex} = this.state;

    const {stage, bg, titleImg, answer} = QuestionCfg[quesIndex];

    // 当前题目
    return <div className="answerpage modal_center">
      <div
        className="bg"
        style={{
          backgroundImage: `url(${bg})`,
        }}
      />

      <div className="stage">{stage}</div>
      <div className="quesArea">
        <div className="queIndex">
          <span>1</span>
          <text>/</text>
          6
        </div>
        <div className="questionArea">
          <img
            src={titleImg}
            style={{
              transformOrigin: 'top left',
              transform: `scale(${window.remScale}) translateY(50%)`
            }}
          />
        </div>

        <div className="answerArea">
          {answer.map((item, index) => {
            const cls = classNames(
              "answerItem",
              {
                active: index === chooseIndex,
              }
            );
            return <div
              className={cls}
              onClick={this.clickItem.bind(this, index)}
            >{item.txt}</div>
          })}
        </div>

      </div>
      <Button className="confirm"/>
    </div>;
  }
}

export default Answerpage;
