/*
 * @Author: super
 * @Date: 2021-01-20 14:08:27
 * @LastEditTime: 2021-01-20 14:53:39
 * @LastEditors: super
 * @Description:
 */
/**
 * 弹窗优先级 可以是负数， 不写默认是10， 数值越小，层级越高
 */
export const MODAL_INDEX = {
  // rank: 1,
};
/** 网络异常默认展示 */
export const DEFAULT_NET_ERROR = '网络异常，请稍后再试';

export const PAGE_MAP = {
  HOME_PAGE: "homePage",
  LOADING_PAGE: "loadingPage",
  DRAW_PAGE: "drawPage",
  PRIZE_PAGE: "prizePage",
  MID_PAGE: "midPage",
  QUES_PAGE: "quesPage",
  RESU_PAGE: "resultPage"
};



/**
 * 渠道参数
 * 1.官微菜单栏 guanwei
 * 2.官微权益中心 quanyizhongxin
 * 3.寿险小程序 shouxian
 * 4.官微推文 tuiwen
 * 5.长航加油站 dingdong
 * 6.太好钉 taihaoding
 * 7.海报 haibao
 * 8.太好店小程序
 * 9.官微服务大厅
 * 10.集团app
 */
export const CHANNEL_PARAMS = {
  /** 官微菜单栏 */
  GW_MENU: "guanwei",
  /** 官微权益中心 */
  GW_EQUITY: "quanyizhongxin",
  /** 寿险小程序 */
  SHOUXIAN_MINI: "shouxian",
  /** 官微推文 */
  GW_TWEET: "tuiwen",
  /** 长航加油站（公众号） */
  CHANG_HANG: "dingdong",
  /** 太好钉 */
  THD: "taihaoding",
  /** 海报 */
  POSTER: "haibao",
  /** 太好店小程序 */
  THD_MINI: "taihaodian",
  /** 官微服务大厅 */
  FUWU: "fuwu",
  /** 集团app */
  APP: "app",
  /** 心意商城小程序 */
  XINYI: "xinyi",
  /** 年报活动 */
  NIANBAO: "nianbao",
  /** 订阅号 */
  DINGYUEHAO: "dingyuehao",
}


/** 神策 sysSourceName渠道参数 */
export const SYS_SOURCE_CHANNEL = {
  /** 官微菜单栏 */
  [CHANNEL_PARAMS.GW_MENU]: "官微",
  /** 官微权益中心 */
  [CHANNEL_PARAMS.GW_EQUITY]: "官微",
  /** 寿险小程序 */
  [CHANNEL_PARAMS.SHOUXIAN_MINI]: "官微",
  /** 官微推文 */
  [CHANNEL_PARAMS.GW_TWEET]: "官微",
  /** 长航加油站（公众号） */
  [CHANNEL_PARAMS.CHANG_HANG]: "个险",
  /** 太好钉 */
  [CHANNEL_PARAMS.THD]: "官微",
  /** 海报 */
  [CHANNEL_PARAMS.POSTER]: "官微",
  /** 太好店小程序 */
  [CHANNEL_PARAMS.THD_MINI]: "个险",
  /** 官微服务大厅 */
  [CHANNEL_PARAMS.FUWU]: "官微",
  /** 集团app */
  [CHANNEL_PARAMS.APP]: "官微",
  /** 心意商城小程序 */
  [CHANNEL_PARAMS.XINYI]: "官微",
  /** 年报活动 */
  [CHANNEL_PARAMS.NIANBAO]: "官微",
  /** 订阅号 */
  [CHANNEL_PARAMS.DINGYUEHAO]: "官微",
}

/** 神策 activitySource渠道参数 */
export const ACTIVITY_SOURCE_CHANNEL = {
  /** 官微菜单栏 */
  [CHANNEL_PARAMS.GW_MENU]: "官微菜单栏",
  /** 官微权益中心 */
  [CHANNEL_PARAMS.GW_EQUITY]: "官微权益中心",
  /** 寿险小程序 */
  [CHANNEL_PARAMS.SHOUXIAN_MINI]: "寿险小程序",
  /** 官微推文 */
  [CHANNEL_PARAMS.GW_TWEET]: "官微推文",
  /** 长航加油站（公众号） */
  [CHANNEL_PARAMS.CHANG_HANG]: "长航加油站",
  /** 太好钉 */
  [CHANNEL_PARAMS.THD]: "太好钉",
  /** 海报 */
  [CHANNEL_PARAMS.POSTER]: "海报",
  /** 太好店小程序 */
  [CHANNEL_PARAMS.THD_MINI]: "太好店小程序",
  /** 官微服务大厅 */
  [CHANNEL_PARAMS.FUWU]: "官微服务大厅",
  /** 集团app */
  [CHANNEL_PARAMS.APP]: "集团app",
  /** 心意商城小程序 */
  [CHANNEL_PARAMS.XINYI]: "心意商城小程序",
  /** 年报活动 */
  [CHANNEL_PARAMS.NIANBAO]: "年报活动",
  /** 订阅号 */
  [CHANNEL_PARAMS.DINGYUEHAO]: "订阅号",
}




/**
 * 活动状态(前端定义)
*/
export const ACT_STATUS = {
  /** 未开始 */
  NOT_START: '1',
  /** 进行中 */
  ING: '2',
  /** 已结束 */
  ENDED: '3',
}



/**
 * 活动状态toast
 */
export const ACT_STATUS_TOAST = {
  /** 未开始 */
  [ACT_STATUS.NOT_START]: '活动尚未开始',
  /** 已结束 */
  [ACT_STATUS.ENDED]: '活动已经结束',
}


/**
 * 任务code
*/
export const TASK_CODE = {
  /** 每日签到 */
  SIGN: 'common_sign',
  /** 浏览产品 */
  BROWSE_PRODUCT: 'browse_product',
  /** 1v1留资查询 */
  THIRD_RETAIN: 'third_retain',
  /** 浏览视频 */
  BROWSE_VIDEO: 'browse_view',
  /** 浏览小程序页面 */
  BROWSE_MINI: 'browse_view_mini',
}

/**
 * 答题配置 共5组 每组5道题
 */
export const TOPIC_LIST = [
  // 第一组
  [
    {
      topic: "端午节必吃粽子，你更偏爱哪种口味？",
      options: [
        "甜粽派(豆沙、蜜枣)$$$a",
        "咸粽派(蛋黄肉粽、火腿)$$$a",
        "冰粽等创新粽子$$$c",
      ]
    },
    {
      topic: "端午节时，你希望收到什么样的祝福？",
      options: [
        "创意满满的搞笑段子",
        "传统又温馨的话语",
        "简单一句“端午快乐”"
      ]
    },
    {
      topic: "如果粽子有性格，你希望它是？",
      options: [
        "粽子怎么可能有性格",
        "热情似火的小太阳",
        "古灵精怪的小精灵"
      ]
    },
    {
      topic: "假如端午假期和朋友约饭，你选？",
      options: [
        "亲自为朋友做粽子盛情款待$$$e",
        "找家网红餐厅尝鲜",
        "在家等朋友投喂"
      ]
    },
    {
      topic: "端午节一些地方会举办爬龙舟比赛，你想？",
      options: [
        "亲自下场，感受速度激情$$$b",
        "岸边助威，当最强气氛组",
        "线上围观，不想出门凑热闹$$$d"
      ]
    },
  ],
  // 第二组
  [
    {
      topic: "当听说有的地方端午用雄黄酒在小孩额头写“王”字，你？",
      options: [
        "觉得很有趣，想给孩子试试$$$c",
        "新奇，但不会轻易尝试",
        "这操作有点迷，不太理解"
      ]
    },
    {
      topic: "端午期间，你愿意花时间学编五彩绳吗？",
      options: [
        "必须的，编好送亲友多有面$$$a",
        "可以试试，毕竟是传统文化$$$a",
        "太麻烦了，直接买现成的$$$d"
      ]
    },
    {
      topic: "端午节你会邀请朋友来家里吗？",
      options: [
        "肯定会，组织一场热闹的聚会$$$b",
        "看情况，有时间就邀请$$$a",
        "不会，喜欢自己过节"
      ]
    },
    {
      topic: " 假如粽子会上网，它发的第一条动态会是？",
      options: [
        "“家人们谁懂啊，被包得好紧”",
        "“今天和隔壁月饼battle了一下人气”",
        "“谁来尝尝我的新馅料，绝了”"
      ]
    },
    {
      topic: "对于粽子的搭配，你有研究吗？",
      options: [
        "会研究各种新奇搭配和茶点$$$e",
        "随便搭配，能吃就行",
        "没有，就正常吃粽子"
      ]
    },
  ],
  // 第三组
  [
    {
      topic: "你觉得端午节吃粽子，什么最重要？",
      options: [
        "必须是独特的口味",
        "精致好看的外形",
        "亲手制作的心意"
      ]
    },
    {
      topic: "端午节公司搞活动，你希望是？",
      options: [
        "包粽子大赛，展示自己的手艺$$$e",
        "粽子创意摆盘比赛，看谁脑洞大",
        "放假一天，在家躺平"
      ]
    },
    {
      topic: "有些地方端午节有“躲午”的习俗，你怎么看？",
      options: [
        "很有意思，想了解更多",
        "不太理解，感觉没必要",
        "尊重习俗，但不参与"
      ]
    },
    {
      topic: "假如有个粽子博物馆，你觉得里面会有？",
      options: [
        "从古至今各种传统粽子模具，展示历史$$$a",
        "世界各地奇葩粽子的标本，大开眼界$$$c",
        "休息区，逛累了可以吃粽子$$$d"
      ]
    },
    {
      topic: "朋友邀请你参加端午节户外活动，你会？",
      options: [
        "马上答应，还主动帮忙策划$$$b",
        "犹豫一下，看自己的安排",
        "找借口拒绝，想在家休息"
      ]
    },
  ],
  // 第四组
  [
    {
      topic: "端午节一些地区有“送时节”的习俗，你知道是指？",
      options: [
        "送应季礼品走亲访友",
        "给亲朋好友送祝福",
        "不太清楚，没听说过"
      ]
    },
    {
      topic: "假如端午节有专属宠物装扮，你会给宠物？",
      options: [
        "精心打扮，拍照发圈$$$c",
        "偶尔试试，图个乐呵",
        "算了，感觉很麻烦"
      ]
    },
    {
      topic: "假如粽子会唱歌，你觉得它会唱？",
      options: [
        "《最炫民族风》，经典永不褪色",
        "《卡路里》，吃了不怕胖",
        "《无所谓》，和自己的心态一样"
      ]
    },
    {
      topic: "端午当天，你会选择什么活动？",
      options: [
        "观看传统的龙舟比赛，感受古老的竞技氛围$$$a",
        "看看电视里的端午节目，轻松度过$$$d",
        "参加粽子品鉴会，品尝各地特色粽子$$$e"
      ]
    },
    {
      topic: "端午节在社交平台，你：",
      options: [
        "频繁发动态，邀请大家线下玩$$$b",
        "偶尔发一条祝福动态",
        "基本不看也不发动态"
      ]
    },
  ],
  // 第五组
  [
    {
      topic: "端午节时，你会选择哪种方式放松？",
      options: [
        "泡个艾草澡，舒缓身心",
        "DIY端午美食，招待好友$$$e",
        "和朋友逛街喝咖啡"
      ]
    },
    {
      topic: "你觉得端午节的龙舟竞渡，最吸引人的是？",
      options: [
        "紧张刺激的比赛氛围",
        "独特的龙舟造型和装饰",
        "大家齐心协力的团队精神"
      ]
    },
    {
      topic: "看到商家推出的端午限定产品，你会？",
      options: [
        "选择具有传统特色的产品，支持传统文化$$$a",
        "买一些和朋友分享，增加节日氛围$$$b",
        "购买最有创意、最新奇的限定产品$$$c"
      ]
    },
    {
      topic: "假如粽子拥有超能力，你希望它具备什么神奇技能？",
      options: [
        "能自己包自己，还能变出各种馅料",
        "能瞬间变成各种新奇口味，永远吃不腻",
        "不需要什么技能，随遇而安就好$$$d"
      ]
    },
    {
      topic: "如果你穿越成屈原，你会？",
      options: [
        "举办第一届粽子品鉴大会",
        "把离骚改编成说唱，宣传端午",
        "先找个地方好好睡一觉，太操心了"
      ]
    },
  ],
]

/**
 * 人设信息
 */
export const ROLE_MAP = {
  // a 传统守护者
  // b 社交组局王
  // c 狂热尝新党
  // d 佛系随性派
  // e 元气美食家
  a: {
    name: "传统守护者",
    productName: "太保岁优保（2024版）两全保险",
    productLink: "https://yun.duiba.com.cn/polaris/%E5%B2%81%E4%BC%98%E4%BF%9D.ea5556dd06efd9d929ad9d8617fa896d3164eae9.jpg",
  },
  b: {
    name: "社交组局王",
    productName: "太保蛮好人生（传世）终身寿险（分红型）",
    productLink: "https://yun.duiba.com.cn/polaris/%E8%9B%AE%E5%A5%BD%E4%BA%BA%E7%94%9F%E9%95%BF%E5%9B%BE.867da0febb90ed822ee5180f0d7c216dba306b3b.jpg",
  },
  c: {
    name: "狂热尝新党",
    productName: "太保爱心保（尊享2024）重大疾病保险",
    productLink: "https://yun.duiba.com.cn/polaris/%E7%88%B1%E5%BF%83%E4%BF%9D.ff0c1419a91b0be23d378eadd24e447ed621ce17.jpg",
  },
  d: {
    name: "佛系随性派",
    productName: "太保安享百万2025医疗保险（费率可调）",
    productLink: "https://yun.duiba.com.cn/polaris/5%E3%80%81%E5%AE%89%E4%BA%AB2025%E9%95%BF%E5%9B%BE.c644f11434fe71c7bdead8267757240452886f5c.jpg",
  },
  e: {
    name: "元气美食家",
    productName: "金生无忧2024（成人版)保险产品计划",
    productLink: "https://yun.duiba.com.cn/polaris/%E9%87%91%E7%94%9F%E6%97%A0%E5%BF%A7%EF%BC%88%E6%88%90%E4%BA%BA%EF%BC%89.46c5cd14e1c5e4bfe4cf6950bc407add9e5671ae.jpg",
  },
}