'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './resultpage.less';
import store from '@src/store';
import { Button } from '@src/components/Button';
import { _throttle } from '@src/utils/utils';
import modalStore from '@src/store/modal';
import { PAGE_MAP, ROLE_MAP } from '@src/utils/constants';
import shareStore from '@src/store/share';
import { sensorMdClick, sensorMdExpouse } from '@src/utils/sensorMd';
import { hideLoading, showLoading } from '@spark/ui';
import { htmlShot } from '@spark/utils';

@observer
class Resultpage extends React.Component {
  constructor(props) {
    super(props);
    this.state = {
      poster: null,
    };
  }
  async componentDidMount() {
    sensorMdExpouse("activityPage", { pageName: "结果页", follow_action: 3 });
    showLoading();
    await this.doCreatePoster();
    this.pageRef?.scrollTo(0, 240 * window.remScale);
  }

  /** 合成海报 */
  doCreatePoster = async () => {
    setTimeout(async () => {
      const url = await htmlShot(this.shotRef)
      this.setState({ poster: url })
      hideLoading()
    }, 500);
  };


  doShare = _throttle(() => {
    sensorMdClick("activityClick", { pageName: "结果页", buttonName: "分享人设" });
    shareStore.doShare();
  })
  goDraw = _throttle(() => {
    sensorMdClick("activityClick", { pageName: "结果页", buttonName: "立即抽奖" });
    store.changePage(PAGE_MAP.DRAW_PAGE, { is_from: 'result' });
  })
  // 查看产品详情
  openProduct = _throttle(() => {
    sensorMdClick("activityClick", { pageName: "结果页", buttonName: "点击查看" });
    modalStore.pushPop("LongImgPop2", { imgUrl: ROLE_MAP[store.roleId].productLink })
  })

  backHandle = _throttle(() => {
    sensorMdClick("activityClick", { pageName: "结果页", buttonName: "返回" });
    store.changePage(PAGE_MAP.HOME_PAGE)
  })

  render() {
    const { poster } = this.state;
    return (
      <div className="com_Container" ref={r => this.pageRef = r}>
        <div className="resultpage">
          <div className="shot_content" ref={r => this.shotRef = r}>
            <span className="bg"></span>
            <span className={`role_${store.roleId}`}></span>
            <div className="code_boc">
              <span className="code_bg"></span>
              <img className="code_img" src={store.frontVariable.posterQrCode} alt="" />
            </div>
          </div>
          {poster && <img className="poster_img" src={poster} style={{ opacity: 0 }} alt="" />}
          <Button className={`product_btn type_${store.roleId}`} onClick={this.openProduct}></Button>
          <div className="bottom_btn">
            <Button className="share_btn md9" onClick={this.doShare}></Button>
            <Button className="draw_btn md8" onClick={this.goDraw}></Button>
            <span className="tips">长按保存海报分享</span>
          </div>
          <Button className="back_btn" onClick={this.backHandle}></Button>
        </div>
      </div>
    );
  }
}
export default Resultpage;
