'use strict';

import React from 'react';
import { observer } from 'mobx-react';
import './drawsucpop.less';
import store from '@src/store';
import { PAGE_MAP } from '@src/utils/constants';
import { Button } from '../Button';
import { _throttle } from '@src/utils/utils';
import modalStore from '@src/store/modal';
import { sensorMdClick, sensorMdExpouse } from '@src/utils/sensorMd';
import { SvgaPlayer } from '@spark/svgaplayer';
import { RES_PATH } from '../../../sparkrc';

@observer
class Drawsucpop extends React.Component {
  constructor(props) {
    super(props);
  }

  componentDidMount() {
    sensorMdExpouse("PopupExpouse", { pageName: "中奖弹窗", prize: this.props?.popData?.prizeName });
  }

  /** 进入【奖品】页 */
  jumpPrize = _throttle(() => {
    sensorMdClick("PopupClick", { pageName: "中奖弹窗点击", buttonName: "开心收下", prize: this.props?.popData?.prizeName });
    modalStore.closePop();
    location.href = CFG.prize;
  })
  render() {
    const { prizeName, prizeImg } = this.props.popData || {}
    return (
      <div className="drawsucpop modal_center">
        <SvgaPlayer className="light" src={RES_PATH + "svga/pop.svga"} />
        <span className="leaves"></span>
        <span className="bg"></span>
        <img className="prize_img" src={prizeImg} />
        <span className="prize_name">{prizeName}</span>
        <Button className="happy_btn md11" onClick={this.jumpPrize}></Button>
        <span className="tips">奖品可在首页 我的奖品 中查看</span>
      </div>
    );
  }
}
export default Drawsucpop;
