import React from "react";
import {observer} from "mobx-react";
import "./FundsPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import {Button} from "@src/components/Button";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";

@observer
class FundsPanel extends React.Component {

  componentDidMount() {
  }

  clickNext = () => {
    store.changePage(PAGE_MAP.QUES_PAGE, {funds: this.props.popData.funds});
  }

  render() {
    const {funds} = this.props.popData;

    // 当前题目
    return <div className="FundsPanel modal_center">
      <SvgaPlayer className="effect" src={RES_PATH + "svga/2输出弹窗氛围.svga"}/>
      <div className="bg"/>
      <div className="funds">{funds}万元</div>
      <Button className="next" onClick={this.clickNext}/>
      <Button className="close" onClick={this.clickNext}/>
    </div>;
  }
}

export default FundsPanel;
