import { generateAPI } from "./utils.js"

const API = generateAPI({
	/** 获取活动规则 */
	getRule: 'projectRule.query',
	/** 获取前端配置项 */
	getFrontVariable: 'coop_frontVariable.query',
	/** 参与接口 post请求 */
	doJoin: {
		uri: 'join.do',
		method: "post"
	},
	/** 签到 */
	doSign: {
		uri: 'checkin_1/doSign.do',
		withToken: true,  // 携带token
	},

  // cookie丢失-临时保存cookie
  tempSaveCookie: {
    uri: "/autoLogin/tempSaveCookie",
    showMsg: false,
  },
  // cookie丢失-重新设置cookie
  resetCookie: "/autoLogin/resetCookie",
  userLogin: {
    uri: "userLogin.check",
    showMsg: false,
  },
  buriedPoint: {
    uri: "home/buriedPoint.do",
    showMsg: false,
  },

  home: 'home/index.do',
  startAnswer: {
    uri: 'game/startGame.do',
    withToken: true,  // 携带token
  },
  submitAnswer: {
    uri: 'home/submitAnswer.do',
    withToken: true,  // 携带token
  },

  /** 抽奖首页 */
  drawIndex: "home/drawIndex.do",
  /** 抽奖 */
  drawJoin: {
    uri: "home/doDraw.do",
    withToken: true,
  },

	/** 查询用户信息(神策埋点用) */
	queryUserInfo: "common/queryUserInfo.do",

  /** 查询任务列表 */
  queryTasks: "task_1/queryTasks.do",
  /** 完成任务 */
  doCompleted: {
    method: "post",
    uri: "task_1/doCompleted.do",
    withToken: true,
  },
  /** 任务发奖 */
  sendPrize: {
    method: "post",
    uri: "task_1/sendPrize.do",
    withToken: true,
  },

	/** 奖品页信息 */
	getPrizePageInfo: "common/prizeRecord.do",
	createCode: "/customActivity/taibao/custom/createCode",
	thdLoginNew: {
		uri: '/customActivity/taibao/thd/authLogin'
	},
	tbLoginNew: {
		uri: 'https://customer-link.duiba.com.cn/customer/93842/taibao/login'
	},
})

// console.log('======', API)

export default API
