"use strict";

import React, { forwardRef } from "react";
import { observer } from "mobx-react";
import "./wxOpenModule.less";

const WxOpenModule = observer(forwardRef((props, ref) => {
  console.info("WxOpenModule-props:",props)
  return (
    <div className="wxOpenModule">
      <wx-open-launch-weapp
        id = {props.id}
        ref={ref}
        username={props.username}
        appid={props.appid}
        path={props.path}
        env-version = {props?.envVersion||'release'}
        style={{ width: "100%", height: "100%", top: '0', left: '0', display: "block", border: "none", background: "none", opacity: 1, overflow: "hidden" }}
      >
        <script type="text/wxtag-template">
          <button style={{ width: "2.78rem", height: "0.95rem", display: "block", border: "none", background: "none", opacity: 1 }}></button>
        </script>
      </wx-open-launch-weapp>
    </div>
  )
}))

export default WxOpenModule;
