import React from "react";
import {observer} from "mobx-react";
import "./ReviewPanel.less";
import {SvgaPlayer} from "@spark/svgaplayer";
import {RES_PATH} from "../../../sparkrc";
import {Button} from "@src/components/Button";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";
import modalStore from "@src/store/modal";

@observer
class ReviewPanel extends React.Component {
  state = {
    itemsVisible: new Array(5).fill(false),
    animationCompleted: false
  };

  t = 0;

  componentDidMount() {
    // 延迟启动动画
    setTimeout(() => {
      this.startAnimation();
    }, 200);
  }

  componentWillUnmount() {
    clearTimeout(this.t);
  }

  startAnimation = () => {
    // 逐个显示 item
    this.state.itemsVisible.forEach((_, index) => {
      setTimeout(() => {
        this.setState(prevState => ({
          itemsVisible: prevState.itemsVisible.map((visible, i) =>
            i === index ? true : visible
          )
        }));

        // 最后一个 item 显示后，等待动画完成再设置完成状态
        if (index === this.state.itemsVisible.length - 1) {
          setTimeout(() => {
            this.setState({ animationCompleted: true });
            this.t = setTimeout(()=>{
              this.clickNext();
            }, 5000);
          }, 600); // 等待最后一个 item 的动画完成 (0.6s)
        }
      }, index * 300); // 每个 item 延迟 300ms
    });
  };

  clickNext = () => {
    // 只有在动画完成后才允许点击
    if (!this.state.animationCompleted) {
      return;
    }
    modalStore.closePop();
  }

  render() {
    const {review} = this.props.popData;
    const {itemsVisible, animationCompleted} = this.state;

    // 当前题目
    return (
      <div
        className={`ReviewPanel modal_center ${animationCompleted ? 'animation-completed' : ''}`}
        onClick={this.clickNext}
      >
        <SvgaPlayer className="effect" src={RES_PATH + "svga/2输出弹窗氛围.svga"}/>
        <div className="bg"/>
        <div className="items-container">
          {
            review.map((item, index) => {
              return (
                <div
                  key={index}
                  className={`item item${index % 2} ${itemsVisible[index] ? 'item-visible' : ''}`}
                  style={{
                    top: (317 + index * 250) * remScale,
                  }}
                >
                  <div className="title">{item.title}</div>
                  <div className="txt">{item.txt}</div>
                </div>
              );
            })
          }
        </div>
        {animationCompleted && <div className={`tip`}>
          点击屏幕继续测试
        </div>}
      </div>
    );
  }
}

export default ReviewPanel;
