import React from "react";
import {observer} from "mobx-react";
import "./LifeSettingPage.less";
import {_asyncThrottle, _throttle, waitTime} from "@src/utils/utils";
import {Button} from "@src/components/Button";
import classNames from "classnames";
import {SettingCfg} from "@src/pages/LifeSettingPage/SettingCfg";
import store from "@src/store";
import {PAGE_MAP} from "@src/utils/constants";
import {Toast} from "@spark/ui";
import modalStore from "@src/store/modal";
import { sensorMdClick, sensorMdExpouse } from "@src/utils/sensorMd";

@observer
class LifeSettingPage extends React.Component {
  state = {
    quesIndex: 0,
    chooseIndex: null,
  };

  funds = 100;

  settingParams = [];

  componentDidMount() {
    sensorMdExpouse("activityPage", { pageName: "人生参数设定页" });
  }

  clickItem(index) {
    this.setState({
      chooseIndex: index,
    });
  }

  clickNext = () => {
    const {chooseIndex, quesIndex} = this.state;

    if (chooseIndex === null || chooseIndex === undefined) {
      return Toast("请完成参数选择", 1800, {hideOthers: true});
    }

    const {radio} = SettingCfg[quesIndex].answer[chooseIndex];

    this.funds *= radio;

    this.settingParams.push(chooseIndex);

    if (quesIndex == 2) {
      sensorMdClick("activityClick", { pageName: "人生参数设定页", buttonName: "开始测试" });
      modalStore.pushPop("FundsPanel", {
        funds: this.funds,
        settingParams: this.settingParams.map((item) => item + 1),
      });
      return;
    }

    this.setState({
      chooseIndex: null,
      quesIndex: quesIndex + 1,
    });
  }

  render() {
    const {quesIndex, chooseIndex} = this.state;

    const {titleImg, answer} = SettingCfg[quesIndex];

    // 当前题目
    return <div className="LifeSettingPage modal_center">
      <div className="bg"/>
      <div className="title"/>
      <img className="quesTitle" src={titleImg}/>

      <div className="answerArea">
        {answer.map((item, index) => {
          return <div className="answerItem" onClick={this.clickItem.bind(this, index)}>
            <img src={item.img}/>
            {chooseIndex === index && <div className="choose"/>}
          </div>
        })}
      </div>

      <Button
        className={classNames("confirm", `md${7 + quesIndex}`, {
          gray: chooseIndex === null || chooseIndex === undefined,
        })}
        onClick={this.clickNext}
      >
        {quesIndex == 2 ? "开始测试" : `继续选择(${quesIndex + 1}/3)`}
      </Button>
    </div>;
  }
}

export default LifeSettingPage;
